/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;
import org.codehaus.cargo.util.log.Logger;

public final class ResourceUtils
extends LoggedObject {
    private static FileHandler defaultFileHandler = new DefaultFileHandler();
    private static ClassLoader resourceLoader = ResourceUtils.class.getClassLoader();

    public static ClassLoader getResourceLoader() {
        return resourceLoader;
    }

    public static void setResourceLoader(ClassLoader resourceLoader) {
        ResourceUtils.resourceLoader = resourceLoader;
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        defaultFileHandler.setLogger(logger);
    }

    public void copyResource(String resourceName, File destFile) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(String resourceName, String destFile, FileHandler handler) throws IOException {
        InputStream in = resourceLoader.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        try (OutputStream out = handler.getOutputStream(destFile);){
            int numBytes;
            byte[] buf = new byte[4096];
            while ((numBytes = in.read(buf)) > 0) {
                out.write(buf, 0, numBytes);
            }
        }
        finally {
            in.close();
        }
    }

    public void copyResource(String resourceName, File destFile, Map<String, String> replacements, Charset encoding) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler, replacements, encoding);
    }

    public void copyResource(String resourceName, String destFile, FileHandler handler, Map<String, String> replacements, Charset encoding) throws IOException {
        handler.writeTextFile(destFile, this.readResource(resourceName, replacements, encoding), encoding);
    }

    public File getResourceLocation(Class where, String resourceName) {
        URL url = where.getResource(resourceName);
        if (url == null) {
            throw new CargoException("Cannot find resource [" + resourceName + "]");
        }
        File file = null;
        String urlString = url.toString();
        if (urlString.startsWith("jar:file:")) {
            int pling = urlString.indexOf(33);
            String jar = urlString.substring(9, pling);
            try {
                file = new File(URLDecoder.decode(jar, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 encoding is missing", e);
            }
        }
        if (urlString.startsWith("file:")) {
            int tail = urlString.indexOf(resourceName);
            String dir = urlString.substring(5, tail);
            try {
                file = new File(URLDecoder.decode(dir, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 encoding is missing", e);
            }
        }
        this.getLogger().debug("Location for [" + resourceName + "] is [" + file + "]", ((Object)((Object)this)).getClass().getName());
        return file;
    }

    public String readResource(String resourceName, Map<String, String> replacements, Charset encoding) throws IOException {
        try (InputStream resource = resourceLoader.getResourceAsStream(resourceName);){
            String string;
            if (resource == null) {
                throw new CargoException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(resource, encoding));){
                String line;
                StringBuilder out = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) {
                        out.append(FileHandler.NEW_LINE);
                        continue;
                    }
                    if (out.length() > 0) {
                        out.append(FileHandler.NEW_LINE);
                    }
                    out.append(line);
                }
                String output = out.toString();
                if (replacements != null) {
                    for (Map.Entry entry : replacements.entrySet()) {
                        String replacementKey = "@" + (String)entry.getKey() + "@";
                        output = output.replace(replacementKey, (CharSequence)entry.getValue());
                    }
                }
                string = output;
            }
            return string;
        }
    }
}

