/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration.builder;

import java.util.Map;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.DataSourceSupport;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.configuration.entry.ResourceSupport;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.util.DefaultXmlFileBuilder;

public abstract class AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder
extends AbstractStandaloneLocalConfiguration
implements DataSourceSupport,
ResourceSupport {
    public AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder(String dir) {
        super(dir);
    }

    protected abstract Map<String, String> getNamespaces();

    protected abstract String getXpathForDataSourcesParent();

    protected abstract String getXpathForResourcesParent();

    protected abstract String getOrCreateDataSourceConfigurationFile(DataSource var1, LocalContainer var2);

    protected abstract String getOrCreateResourceConfigurationFile(Resource var1, LocalContainer var2);

    protected abstract ConfigurationBuilder createConfigurationBuilder(LocalContainer var1);

    @Override
    public void configure(LocalContainer container) {
        super.configure(container);
        this.configureDataSources(container);
        this.configureResources(container);
    }

    @Override
    public void configureDataSources(LocalContainer container) {
        for (DataSource dataSource : this.getDataSources()) {
            this.configure(dataSource, container);
        }
    }

    @Override
    public void configure(Resource ds, LocalContainer container) {
        ConfigurationBuilder builder = this.createConfigurationBuilder(container);
        String xml = builder.toConfigurationEntry(ds);
        String file = this.getOrCreateResourceConfigurationFile(ds, container);
        this.writeConfigurationToXpath(file, xml, this.getXpathForResourcesParent());
    }

    @Override
    public void configureResources(LocalContainer container) {
        for (Resource resource : this.getResources()) {
            this.configure(resource, container);
        }
    }

    @Override
    public void configure(DataSource ds, LocalContainer container) {
        ConfigurationBuilder builder = this.createConfigurationBuilder(container);
        String file = this.getOrCreateDataSourceConfigurationFile(ds, container);
        String xml = builder.toConfigurationEntry(ds);
        this.writeConfigurationToXpath(file, xml, this.getXpathForDataSourcesParent());
    }

    protected void writeConfigurationToXpath(String file, String xml, String path) {
        DefaultXmlFileBuilder manager = new DefaultXmlFileBuilder(this.getFileHandler());
        manager.setNamespaces(this.getNamespaces());
        manager.setFile(file);
        manager.loadFile();
        manager.insertElementsUnderXPath(xml, path);
        manager.writeFile();
    }
}

