/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.jvm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.codehaus.cargo.util.log.Logger;

public class DefaultJvmLauncherLoggerRedirector
implements Runnable {
    private final InputStream inputStream;
    private Logger outputLogger;
    private String category;

    public DefaultJvmLauncherLoggerRedirector(InputStream inputStream, Logger outputLogger, String category) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream should not be null");
        }
        this.inputStream = inputStream;
        this.outputLogger = outputLogger;
        this.category = category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.outputLogger.info(line, this.category);
            }
        }
        catch (Exception e) {
            this.outputLogger.warn("Error reading process stream: " + e, this.getClass().getName());
            return;
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                return;
            }
        }
    }
}

