/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.spi;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.generic.internal.util.HintKey;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public abstract class AbstractGenericHintFactory
extends MonitoredObject {
    private Map mappings = new HashMap();

    protected AbstractGenericHintFactory() {
    }

    protected boolean hasMapping(String containerId, String hint) {
        HintKey key = new HintKey(containerId, hint);
        return this.mappings.containsKey(key);
    }

    protected void registerImplementation(String containerId, String hint, Class implementationClass) {
        HintKey key = new HintKey(containerId, hint);
        this.mappings.put(key, implementationClass);
    }

    protected Object createImplementation(String containerId, String hint, GenericParameters parameters, String implementationConceptName) {
        Object implementation;
        HintKey key = new HintKey(containerId, hint);
        if (!this.mappings.containsKey(key)) {
            throw new ContainerException("Cannot create " + implementationConceptName + ". The pair (container id [" + containerId + "], " + implementationConceptName + " type [" + hint + "]) has not been registered.");
        }
        Class implementationClass = (Class)this.mappings.get(key);
        try {
            Constructor constructor = this.getConstructor(implementationClass, hint, parameters);
            implementation = this.createInstance(constructor, hint, parameters);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create " + implementationConceptName + " for the pair (container id [" + containerId + "], " + implementationConceptName + " type [" + hint + "]).", (Throwable)e);
        }
        return implementation;
    }

    protected abstract Constructor getConstructor(Class var1, String var2, GenericParameters var3) throws NoSuchMethodException;

    protected abstract Object createInstance(Constructor var1, String var2, GenericParameters var3) throws Exception;

    public static interface GenericParameters {
    }
}

