/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.XmlEntityResolver;

public abstract class AbstractDescriptorIo {
    protected AbstractDescriptorIo() {
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new XmlEntityResolver());
        return documentBuilder;
    }

    public static void writeDescriptor(Descriptor descriptor, File file) throws IOException {
        AbstractDescriptorIo.writeDescriptor(descriptor, file, null, false);
    }

    public static void writeDescriptor(Descriptor descriptor, File file, String encoding) throws IOException {
        AbstractDescriptorIo.writeDescriptor(descriptor, file, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDescriptor(Descriptor descriptor, File file, String encoding, boolean isIndent) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            AbstractDescriptorIo.writeDescriptor(descriptor, out, encoding, isIndent);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void writeDescriptor(Descriptor descriptor, OutputStream out, String encoding, boolean isIndent) throws IOException {
        OutputFormat outputFormat = new OutputFormat(descriptor.getDocument());
        if (encoding != null) {
            outputFormat.setEncoding(encoding);
        }
        outputFormat.setIndenting(isIndent);
        outputFormat.setPreserveSpace(false);
        XMLSerializer serializer = new XMLSerializer(out, outputFormat);
        serializer.serialize(descriptor.getDocument());
    }

    public static File[] writeAll(J2eeDescriptor descriptor, String dir) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File webXmlFile = new File(dir, "web.xml");
        AbstractDescriptorIo.writeDescriptor((Descriptor)descriptor, webXmlFile, null, true);
        files.add(webXmlFile);
        Iterator vendorDescriptors = descriptor.getVendorDescriptors();
        while (vendorDescriptors.hasNext()) {
            Descriptor descr = (Descriptor)vendorDescriptors.next();
            File file = new File(dir, descr.getFileName());
            AbstractDescriptorIo.writeDescriptor(descr, file, null, true);
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }
}

