/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.application;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.Dtd;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.application.ApplicationXmlTag;
import org.codehaus.cargo.module.application.ApplicationXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class ApplicationXml
extends AbstractDescriptor
implements J2eeDescriptor {
    private List vendorDescriptors = new ArrayList();

    public ApplicationXml(Document theDocument) {
        super(theDocument, new Dtd("http://java.sun.com/dtd/application_1_3.dtd"));
    }

    public ApplicationXmlVersion getVersion() {
        ApplicationXmlVersion version = null;
        DocumentType docType = this.getDocument().getDoctype();
        if (docType != null) {
            version = ApplicationXmlVersion.valueOf(docType);
        }
        return version;
    }

    public Element getWebModule(String webUri) {
        if (webUri == null) {
            throw new NullPointerException();
        }
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || !webUri.equals(this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI))) continue;
            return webElement;
        }
        return null;
    }

    public String getWebModuleContextRoot(String webUri) {
        Element webModuleElement = this.getWebModule(webUri);
        if (webModuleElement == null) {
            throw new IllegalArgumentException("Web module [" + webUri + "] is not defined");
        }
        return this.getNestedText(webModuleElement, ApplicationXmlTag.CONTEXT_ROOT);
    }

    public Iterator getWebModuleUris() {
        ArrayList<String> webUris = new ArrayList<String>();
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element webElement;
            String webUri;
            Element moduleElement = (Element)moduleElements.next();
            Iterator webElements = this.getNestedElements(moduleElement, ApplicationXmlTag.WEB);
            if (!webElements.hasNext() || (webUri = this.getNestedText(webElement = (Element)webElements.next(), ApplicationXmlTag.WEB_URI)) == null) continue;
            webUris.add(webUri);
        }
        return webUris.iterator();
    }

    public Iterator getEjbModules() {
        ArrayList<String> modules = new ArrayList<String>();
        Iterator moduleElements = this.getElements(ApplicationXmlTag.MODULE);
        while (moduleElements.hasNext()) {
            Element moduleElement = (Element)moduleElements.next();
            String ejb = this.getNestedText(moduleElement, ApplicationXmlTag.EJB);
            if (ejb == null) continue;
            modules.add(ejb);
        }
        return modules.iterator();
    }

    public Iterator getElements(ApplicationXmlTag tag) {
        return super.getElements(tag);
    }

    public void addWebModule(String uri, String context) {
        Element moduleElement = this.getDocument().createElement(ApplicationXmlTag.MODULE.getTagName());
        Element webElement = this.getDocument().createElement(ApplicationXmlTag.WEB.getTagName());
        webElement.appendChild(this.createNestedText(ApplicationXmlTag.WEB_URI, uri));
        webElement.appendChild(this.createNestedText(ApplicationXmlTag.CONTEXT_ROOT, context));
        moduleElement.appendChild(webElement);
        this.addElement(ApplicationXmlTag.MODULE, moduleElement, this.getRootElement());
    }

    public void addEjbModule(String name) {
        Element moduleElement = this.getDocument().createElement(ApplicationXmlTag.MODULE.getTagName());
        moduleElement.appendChild(this.createNestedText(ApplicationXmlTag.EJB, name));
        this.addElement(ApplicationXmlTag.MODULE, moduleElement, this.getRootElement());
    }

    public Iterator getVendorDescriptors() {
        return this.vendorDescriptors.iterator();
    }

    public String getFileName() {
        return "application.xml";
    }
}

