/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.ejb.Entity;
import org.codehaus.cargo.module.ejb.Session;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.jdom.Attribute;
import org.jdom.Element;

public class EjbJarXml
extends AbstractDescriptor
implements J2eeDescriptor {
    private List vendorDescriptors = new ArrayList();

    public EjbJarXml(Element rootElement, DescriptorType type) {
        super(rootElement, type);
    }

    public String getFileName() {
        return "ejb-jar.xml";
    }

    public void addVendorDescriptor(VendorEjbDescriptor descr) {
        this.vendorDescriptors.add(descr);
    }

    public Iterator getVendorDescriptors() {
        return this.vendorDescriptors.iterator();
    }

    public final Iterator getSessionEjbs() {
        ArrayList<Session> ejbs = new ArrayList<Session>();
        Iterator sessionElements = this.getElements("session");
        while (sessionElements.hasNext()) {
            Element sessionElement = (Element)sessionElements.next();
            Session session = new Session();
            Attribute id = sessionElement.getAttribute("id");
            if (id != null) {
                session.setId(id.getValue());
            }
            session.setName(this.getChildText(sessionElement, "ejb-name"));
            session.setLocal(this.getChildText(sessionElement, "local"));
            session.setLocalHome(this.getChildText(sessionElement, "local-home"));
            ejbs.add(session);
        }
        return ejbs.iterator();
    }

    public final Iterator getEntityEjbs() {
        ArrayList<Entity> ejbs = new ArrayList<Entity>();
        Iterator sessionElements = this.getElements("entity");
        while (sessionElements.hasNext()) {
            Element sessionElement = (Element)sessionElements.next();
            Entity entity = new Entity();
            Attribute id = sessionElement.getAttribute("id");
            if (id != null) {
                entity.setId(id.getValue());
            }
            entity.setName(this.getChildText(sessionElement, "ejb-name"));
            entity.setLocal(this.getChildText(sessionElement, "local"));
            entity.setLocalHome(this.getChildText(sessionElement, "local-home"));
            ejbs.add(entity);
        }
        return ejbs.iterator();
    }

    public final Session getSessionEjb(String name) {
        Session result = null;
        Iterator sessions = this.getSessionEjbs();
        while (sessions.hasNext()) {
            Session ejb = (Session)sessions.next();
            if (!ejb.getName().equals(name)) continue;
            result = ejb;
            break;
        }
        return result;
    }

    public final Entity getEntityEjb(String name) {
        Entity result = null;
        Iterator entities = this.getEntityEjbs();
        while (entities.hasNext()) {
            Entity ejb = (Entity)entities.next();
            if (!ejb.getName().equals(name)) continue;
            result = ejb;
            break;
        }
        return result;
    }
}

