/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.Namespace;

public final class WebXmlVersion
implements Comparable {
    public static final WebXmlVersion V2_2 = new WebXmlVersion("2.2", "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd");
    public static final WebXmlVersion V2_3 = new WebXmlVersion("2.3", "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "http://java.sun.com/dtd/web-app_2_3.dtd");
    public static final WebXmlVersion V2_4 = new WebXmlVersion("2.4", "http://java.sun.com/xml/ns/j2ee");
    public static final WebXmlVersion V2_5 = new WebXmlVersion("2.5", "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Servlet 2.5//EN", "http://www.sun.com/software/dtd/appserver/sun-web-app_2_5-0.dtd");
    private String systemId;
    private String version;
    private String publicId;
    private Namespace namespace;

    private WebXmlVersion(String theVersion, String thePublicId, String theSystemId) {
        this.version = theVersion;
        this.publicId = thePublicId;
        this.systemId = theSystemId;
    }

    private WebXmlVersion(String theVersion, String namespaceUri) {
        this.version = theVersion;
        this.namespace = Namespace.getNamespace((String)namespaceUri);
    }

    public int compareTo(Object other) {
        if (other == this || !(other instanceof WebXmlVersion)) {
            return 0;
        }
        float thisVersion = Float.parseFloat(this.version);
        float thatVersion = Float.parseFloat(((WebXmlVersion)other).version);
        return Float.compare(thisVersion, thatVersion);
    }

    public String getVersion() {
        return this.version;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String toString() {
        return this.getVersion();
    }

    public static WebXmlVersion valueOf(DocType theDocType) throws NullPointerException {
        return WebXmlVersion.valueOf(theDocType.getPublicID());
    }

    public static WebXmlVersion valueOf(Element rootElement) {
        String value = rootElement.getAttributeValue("version");
        if ("2.4".equals(value)) {
            return V2_4;
        }
        return null;
    }

    public static WebXmlVersion valueOf(String thePublicId) {
        WebXmlVersion version = null;
        if (V2_2.getPublicId().equals(thePublicId)) {
            version = V2_2;
        } else if (V2_3.getPublicId().equals(thePublicId)) {
            version = V2_3;
        }
        return version;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }
}

