/*
 * ========================================================================
 *
 * Copyright 2003 The Apache Software Foundation. Code from this file
 * was originally imported from the Jakarta Cactus project.
 *
 * Codehaus Cargo, copyright 2004-2011 Vincent Massol, 2012-2025 Ali Tokmen.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * ========================================================================
 */
package org.codehaus.cargo.module.ejb.orion;

import org.codehaus.cargo.module.AbstractDescriptorType;
import org.codehaus.cargo.module.Dtd;

/**
 * EJB JAR XML file for Orion.
 */
public class OrionEjbJarXmlType extends AbstractDescriptorType
{
    /**
     * Static instance.
     */
    private static OrionEjbJarXmlType instance = new OrionEjbJarXmlType();

    /**
     * Protected constructor.
     */
    protected OrionEjbJarXmlType()
    {
        super(null, OrionEjbJarXml.class,
            new Dtd("http://www.oracle.com/technology/ias/dtds/orion-ejb-jar-9_04.dtd"));
    }

    /**
     * Get the static instance.
     * @return The instance
     */
    public static OrionEjbJarXmlType getInstance()
    {
        return instance;
    }
}
