/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.Identifier;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class AbstractDescriptor
extends Document
implements Descriptor {
    private DescriptorType descriptorType;

    public AbstractDescriptor(Element rootElement, DescriptorType descriptorType) {
        super(rootElement);
        if (descriptorType == null) {
            throw new NullPointerException();
        }
        this.descriptorType = descriptorType;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public List<Element> getTags(DescriptorTag tag) {
        return this.getRootElement().getChildren(tag.getTagName(), tag.getTagNamespace());
    }

    @Override
    public List<Element> getTags(String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element child : this.getRootElement().getChildren()) {
            if (!child.getName().equals(tagName)) continue;
            elements.add(child);
        }
        return elements;
    }

    public List<Element> getElements(DescriptorTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag must not be null");
        }
        return this.getChildElements(this.getRootElement(), tag, new ArrayList<Element>());
    }

    public List<Element> getElements(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("tagName must not be null");
        }
        return this.getElements(this.getDescriptorType().getTagByName(tagName));
    }

    private List<Element> getChildElements(Element element, DescriptorTag tag, List<Element> items) {
        if (element == null || tag == null || items == null) {
            throw new IllegalArgumentException("Cannot pass null values to getChildElements");
        }
        items.addAll(element.getChildren(tag.getTagName(), tag.getTagNamespace()));
        List children = element.getChildren();
        for (Element child : children) {
            this.getChildElements(child, tag, items);
        }
        return items;
    }

    protected void checkElement(Element element, DescriptorTag expectedTag) throws IllegalArgumentException {
        if (!expectedTag.getTagName().equals(element.getName())) {
            throw new IllegalArgumentException("Not a [" + expectedTag + "] element");
        }
    }

    protected List<Element> getNestedElements(Element parent, DescriptorTag tag) {
        List nodeList = parent.getChildren(tag.getTagName(), tag.getTagNamespace());
        return new ArrayList<Element>(nodeList);
    }

    protected Element createNestedText(DescriptorTag tag, String text) {
        Element element = new Element(tag.getTagName(), tag.getTagNamespace());
        element.setText(text);
        return element;
    }

    protected String getNestedText(Element parent, DescriptorTag tag) {
        String text = null;
        List nestedElements = parent.getChildren(tag.getTagName(), tag.getTagNamespace());
        if (nestedElements.size() > 0) {
            text = this.getText((Element)nestedElements.get(0));
        }
        return text;
    }

    protected String getText(Element element) {
        return element.getText();
    }

    protected Element getImmediateChild(Element parent, DescriptorTag tag) {
        Element e = null;
        List nl = parent.getChildren();
        for (Element n : nl) {
            if (!n.getName().equals(tag.getTagName())) continue;
            e = n;
        }
        return e;
    }

    protected String getChildText(Element parent, DescriptorTag tag) {
        String text = null;
        Element e = this.getImmediateChild(parent, tag);
        if (e != null) {
            text = this.getText(e);
        }
        return text;
    }

    protected String getChildText(Element parent, String tagName) {
        return this.getChildText(parent, this.getDescriptorType().getTagByName(tagName));
    }

    @Override
    public Element addElement(DescriptorTag tag, Element child, Element parent) {
        Element importedNode = child.detach();
        Element refNode = this.getInsertionPointFor(tag, parent.getName());
        int idx = parent.getContent().indexOf(refNode);
        if (idx == -1) {
            if (!this.containsElement(parent.getChildren(), importedNode)) {
                parent.addContent((Content)importedNode);
            }
        } else {
            while (idx > 0 && parent.getContent(idx - 1) instanceof Comment) {
                --idx;
            }
            if (!this.containsElement(parent.getChildren(), importedNode)) {
                parent.addContent(idx, (Content)importedNode);
            }
        }
        return importedNode;
    }

    protected boolean containsElement(List<Element> haystack, Element needle) {
        for (Element element : haystack) {
            if (!this.sameElement(element, needle)) continue;
            return true;
        }
        return false;
    }

    protected boolean sameElement(Element element1, Element element2) {
        if (!element1.getName().equals(element2.getName())) {
            return false;
        }
        List children1 = element1.getChildren();
        List children2 = element2.getChildren();
        if (children1.size() != children2.size()) {
            return false;
        }
        if (children1.isEmpty()) {
            return this.sameContent(element1, element2);
        }
        for (int i = 0; i < children1.size(); ++i) {
            if (this.sameElement((Element)children1.get(i), (Element)children2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean sameContent(Element element1, Element element2) {
        List<Content> content1 = this.getContentExceptComments(element1);
        List<Content> content2 = this.getContentExceptComments(element2);
        if (content1.size() != content2.size()) {
            return false;
        }
        for (int i = 0; i < content1.size(); ++i) {
            String content1Value = content1.get(i).getValue();
            String content2Value = content2.get(i).getValue();
            if (content1Value == null || content2Value == null) {
                return content1Value == content2Value;
            }
            if (content1Value.equals(content2Value)) continue;
            return false;
        }
        return true;
    }

    protected List<Content> getContentExceptComments(Element element) {
        List content = element.getContent();
        ArrayList<Content> filteredContent = new ArrayList<Content>();
        for (Content contentToCheck : content) {
            if (contentToCheck instanceof Comment) continue;
            filteredContent.add(contentToCheck);
        }
        return filteredContent;
    }

    protected Element getInsertionPointFor(DescriptorTag tag, String parent) {
        List<DescriptorTag> elementOrder = this.getDescriptorType().getGrammar().getElementOrder(parent);
        if (elementOrder == null) {
            return null;
        }
        for (int i = 0; i < elementOrder.size(); ++i) {
            DescriptorTag orderTag = elementOrder.get(i);
            if (!orderTag.equals(tag)) continue;
            for (int j = i + 1; j < elementOrder.size(); ++j) {
                DescriptorTag theTag = elementOrder.get(j);
                List elements = this.getRootElement().getChildren(theTag.getTagName(), theTag.getTagNamespace());
                if (elements.size() <= 0) continue;
                Element result = (Element)elements.get(0);
                return result;
            }
            break;
        }
        return null;
    }

    @Override
    public DescriptorType getDescriptorType() {
        return this.descriptorType;
    }

    @Override
    public Element getTagByIdentifier(DescriptorTag tag, String value) {
        if (value == null || tag == null) {
            throw new NullPointerException();
        }
        Identifier id = tag.getIdentifier();
        if (id != null) {
            List<Element> tags = this.getTags(tag);
            for (Element e : tags) {
                if (!value.equals(id.getIdentifier(e))) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public Element getTagByIdentifier(String tagName, String value) {
        if (value == null || tagName == null) {
            throw new NullPointerException();
        }
        DescriptorTag tag = this.getDescriptorType().getTagByName(tagName);
        Identifier id = tag.getIdentifier();
        if (id != null) {
            List<Element> tags = this.getTags(tagName);
            for (Element e : tags) {
                if (!value.equals(id.getIdentifier(e))) continue;
                return e;
            }
        }
        return null;
    }
}

