/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.util.Map;
import org.codehaus.cargo.util.CargoException;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public class Identifier {
    private XPath xpath;
    private XPath xpathWithoutNamespace;

    public Identifier(String xpath) {
        try {
            this.xpath = XPath.newInstance((String)xpath);
        }
        catch (JDOMException ex) {
            throw new CargoException("Unexpected xpath error", (Throwable)ex);
        }
    }

    public Identifier(Map<String, String> namespaceMap, String xpath) {
        try {
            this.xpath = XPath.newInstance((String)xpath);
            for (Map.Entry<String, String> namespaceEntry : namespaceMap.entrySet()) {
                String ns = namespaceEntry.getKey();
                String uri = namespaceEntry.getValue();
                this.xpath.addNamespace(ns, uri);
            }
            this.xpathWithoutNamespace = XPath.newInstance((String)xpath);
        }
        catch (JDOMException ex) {
            throw new CargoException("Unexpected xpath error", (Throwable)ex);
        }
    }

    public String getIdentifier(Element element) {
        try {
            String identifier = this.xpath.valueOf((Object)element);
            if (identifier == null || identifier.isEmpty()) {
                identifier = this.xpathWithoutNamespace.valueOf((Object)element);
            }
            return identifier;
        }
        catch (Exception ex) {
            return "";
        }
    }
}

