/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.application;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.application.ApplicationXmlTag;
import org.codehaus.cargo.module.application.ApplicationXmlVersion;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Element;

public class ApplicationXml
extends AbstractDescriptor
implements J2eeDescriptor {
    private List<Descriptor> vendorDescriptors = new ArrayList<Descriptor>();

    public ApplicationXml(Element rootElement, DescriptorType type) {
        super(rootElement, type);
    }

    public ApplicationXmlVersion getVersion() {
        ApplicationXmlVersion version = null;
        DocType docType = this.getDocument().getDocType();
        if (docType != null) {
            version = ApplicationXmlVersion.valueOf(docType);
        }
        return version;
    }

    public Element getWebModule(String webUri) {
        if (webUri == null) {
            throw new NullPointerException();
        }
        List<Element> moduleElements = this.getElements("module");
        for (Element moduleElement : moduleElements) {
            Element webElement;
            List<Element> webElements = this.getNestedElements(moduleElement, this.getDescriptorType().getTagByName("web"));
            if (webElements.isEmpty() || !webUri.equals(this.getNestedText(webElement = webElements.get(0), this.getDescriptorType().getTagByName("web-uri")))) continue;
            return webElement;
        }
        return null;
    }

    public String getWebModuleContextRoot(String webUri) {
        Element webModuleElement = this.getWebModule(webUri);
        if (webModuleElement == null) {
            throw new IllegalArgumentException("Web module [" + webUri + "] is not defined");
        }
        return this.getNestedText(webModuleElement, this.getDescriptorType().getTagByName("context-root"));
    }

    public List<String> getWebModuleUris() {
        ArrayList<String> webUris = new ArrayList<String>();
        List<Element> moduleElements = this.getElements("module");
        for (Element moduleElement : moduleElements) {
            Element webElement;
            String webUri;
            List<Element> webElements = this.getNestedElements(moduleElement, this.getDescriptorType().getTagByName("web"));
            if (webElements.isEmpty() || (webUri = this.getNestedText(webElement = webElements.get(0), this.getDescriptorType().getTagByName("web-uri"))) == null) continue;
            webUris.add(webUri);
        }
        return webUris;
    }

    public List<String> getEjbModules() {
        ArrayList<String> modules = new ArrayList<String>();
        List<Element> moduleElements = this.getElements("module");
        for (Element moduleElement : moduleElements) {
            String ejb = this.getNestedText(moduleElement, this.getDescriptorType().getTagByName("ejb"));
            if (ejb == null) continue;
            modules.add(ejb);
        }
        return modules;
    }

    public List<Element> getElements(ApplicationXmlTag tag) {
        return super.getElements(tag);
    }

    public void addWebModule(String uri, String context) {
        Element moduleElement = new Element("module");
        Element webElement = new Element("web");
        webElement.addContent((Content)this.createNestedText(this.getDescriptorType().getTagByName("web-uri"), uri));
        webElement.addContent((Content)this.createNestedText(this.getDescriptorType().getTagByName("context-root"), context));
        moduleElement.addContent((Content)webElement);
        this.addElement(this.getDescriptorType().getTagByName("module"), moduleElement, this.getRootElement());
    }

    public void addEjbModule(String name) {
        Element moduleElement = new Element("module");
        moduleElement.addContent((Content)this.createNestedText(this.getDescriptorType().getTagByName("ejb"), name));
        this.addElement(this.getDescriptorType().getTagByName("module"), moduleElement, this.getRootElement());
    }

    @Override
    public List<Descriptor> getVendorDescriptors() {
        return this.vendorDescriptors;
    }

    @Override
    public String getFileName() {
        return "application.xml";
    }
}

