/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb.weblogic;

import org.codehaus.cargo.module.AbstractDescriptor;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.ejb.EjbDef;
import org.codehaus.cargo.module.ejb.VendorEjbDescriptor;
import org.jdom2.Content;
import org.jdom2.Element;

public class WeblogicEjbJarXml
extends AbstractDescriptor
implements VendorEjbDescriptor {
    public WeblogicEjbJarXml(Element rootElement, DescriptorType type) {
        super(rootElement, type);
    }

    @Override
    public String getFileName() {
        return "weblogic-ejb-jar.xml";
    }

    @Override
    public String getJndiName(EjbDef ejb) {
        String jndiName = null;
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement != null && (jndiName = this.getNestedText(ejbElement, this.getDescriptorType().getTagByName("local-jndi-name"))) == null) {
            jndiName = this.getNestedText(ejbElement, this.getDescriptorType().getTagByName("jndi-name"));
        }
        return jndiName;
    }

    public void addDispatchPolicy(EjbDef ejb, String policy) {
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement == null) {
            throw new IllegalArgumentException("No ejb named " + ejb.getName() + " found.");
        }
        ejbElement.addContent((Content)this.createNestedText(this.getDescriptorType().getTagByName("dispatch-policy"), policy));
    }

    public String getDispatchPolicy(EjbDef ejb) {
        Element ejbElement = this.getEjb(ejb.getName());
        if (ejbElement == null) {
            throw new IllegalArgumentException("No ejb named " + ejb.getName() + " found.");
        }
        String policy = this.getNestedText(ejbElement, this.getDescriptorType().getTagByName("dispatch-policy"));
        return policy;
    }

    private Element getEjb(String ejbName) {
        Element ejbElement = null;
        for (Element nameElement : this.getElements("ejb-name")) {
            String name = nameElement.getText();
            if (!ejbName.equals(name)) continue;
            ejbElement = nameElement.getParentElement();
            break;
        }
        return ejbElement;
    }
}

