/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.codehaus.cargo.module.JarArchive;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJarArchive
implements JarArchive {
    private byte[] content;
    private String sourceFile;
    private FileHandler fileHandler = new DefaultFileHandler();

    public DefaultJarArchive(String file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.sourceFile = file;
        this.content = null;
    }

    public DefaultJarArchive(InputStream inputStream) throws IOException {
        this.sourceFile = null;
        this.content = this.streamToByteArray(inputStream);
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    @Override
    public boolean containsClass(String className) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        return this.getResource(resourceName) != null;
    }

    @Override
    public final String findResource(String name) throws IOException {
        String result = null;
        for (String entryPath : this.getResources("")) {
            String entryName = entryPath;
            int lastSlashIndex = entryName.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                entryName = entryName.substring(lastSlashIndex + 1);
            }
            if (!entryName.equals(name)) continue;
            result = entryPath;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputStream getResource(String path) throws IOException {
        JarInputStream in = null;
        try {
            ZipEntry zipEntry;
            in = this.getContentAsStream();
            while ((zipEntry = in.getNextEntry()) != null) {
                int bytesRead;
                if (!path.equals(zipEntry.getName())) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((bytesRead = in.read(bytes)) != -1) {
                    buffer.write(bytes, 0, bytesRead);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.toByteArray());
                return byteArrayInputStream;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> getResources(String path) throws IOException {
        String normalizedPath = path;
        if (!path.endsWith("/") && !path.equals("")) {
            normalizedPath = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        JarInputStream in = null;
        try {
            ZipEntry zipEntry;
            in = this.getContentAsStream();
            while ((zipEntry = in.getNextEntry()) != null) {
                if (!zipEntry.getName().startsWith(normalizedPath) || zipEntry.getName().equals(normalizedPath)) continue;
                resources.add(zipEntry.getName());
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return resources;
    }

    protected final JarInputStream getContentAsStream() throws IOException {
        if (this.content != null) {
            return new JarInputStream(new ByteArrayInputStream(this.content));
        }
        return new JarInputStream(this.getFileHandler().getInputStream(this.sourceFile));
    }

    @Override
    public void expandToPath(String path) throws IOException {
        this.expandToPath(path, null);
    }

    @Override
    public void expandToPath(String path, FileFilter filter) throws IOException {
        ZipEntry entry;
        JarInputStream inputStream = this.getContentAsStream();
        byte[] buffer = new byte[40960];
        while ((entry = inputStream.getNextEntry()) != null) {
            int read;
            String entryName = entry.getName();
            String outFile = this.getFileHandler().append(path, entryName);
            if (filter != null && !filter.accept(new File(entryName))) continue;
            if (outFile.endsWith("/")) {
                this.getFileHandler().mkdirs(outFile);
                continue;
            }
            if (!this.getFileHandler().exists(this.getFileHandler().getParent(outFile))) {
                this.getFileHandler().mkdirs(this.getFileHandler().getParent(outFile));
            }
            if (!this.getFileHandler().exists(outFile)) {
                this.getFileHandler().createFile(outFile);
            }
            OutputStream out = this.getFileHandler().getOutputStream(outFile);
            while ((read = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.close();
        }
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] streamToByteArray(InputStream inputStream) throws IOException {
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[40960];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

