/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp.merge;

import java.util.List;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.XmlMerger;
import org.codehaus.cargo.module.merge.DescriptorMergerByTag;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.tagstrategy.MergeStrategy;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.module.webapp.elements.FilterMapping;
import org.codehaus.cargo.module.webapp.elements.MimeMapping;
import org.codehaus.cargo.util.CargoException;
import org.jdom.Element;

public class WebXmlMerger
extends XmlMerger {
    private WebXml webXml;
    private DescriptorMergerByTag descriptorMergerByTag = new DescriptorMergerByTag();

    public WebXmlMerger() {
        this.descriptorMergerByTag.setStrategy("login-config", DescriptorMergerByTag.OVERWRITE);
        this.descriptorMergerByTag.setStrategy("filter", DescriptorMergerByTag.IGNORE);
        this.descriptorMergerByTag.setStrategy("filter-mapping", DescriptorMergerByTag.IGNORE);
        this.descriptorMergerByTag.setStrategy("servlet", DescriptorMergerByTag.IGNORE);
        this.descriptorMergerByTag.setStrategy("mime-mapping", DescriptorMergerByTag.IGNORE);
        this.addMerger(this.descriptorMergerByTag);
    }

    public WebXmlMerger(Descriptor base) {
        this();
        this.init(base);
    }

    public void init(Descriptor base) {
        this.webXml = (WebXml)base;
        this.descriptorMergerByTag.setDescriptorType(base.getDescriptorType());
        super.init(base);
    }

    public void setMergeStrategy(String tag, MergeStrategy strategy) {
        this.descriptorMergerByTag.setStrategy(tag, strategy);
    }

    public final void merge(Descriptor theMerge) {
        try {
            WebXml theMergeWebXml = (WebXml)theMerge;
            this.checkServletVersions(theMergeWebXml);
            super.merge(theMerge);
            if (WebXmlVersion.V2_3.compareTo(this.webXml.getVersion()) <= 0) {
                this.mergeFilters(theMergeWebXml);
            }
            this.mergeServlets(theMergeWebXml);
            this.mergeSecurityRoles(theMergeWebXml);
            this.mergeMimeMappings(theMergeWebXml);
        }
        catch (Exception e) {
            throw new MergeException("Exception merging web.xml files", e);
        }
    }

    public WebXml getResult() {
        return this.webXml;
    }

    protected VendorWebAppDescriptor getVendorWebAppDescriptor(WebXml theWebXml, Class clazz) {
        for (Descriptor d : theWebXml.getVendorDescriptors()) {
            VendorWebAppDescriptor descriptor = (VendorWebAppDescriptor)d;
            if (!clazz.isInstance(descriptor)) continue;
            return descriptor;
        }
        return null;
    }

    protected final void checkServletVersions(WebXml theWebXml) {
        if (this.webXml.getVersion() != null && this.webXml.getVersion().compareTo(theWebXml.getVersion()) < 0) {
            this.getLogger().warn("Merging elements from a version " + theWebXml.getVersion() + " descriptor into a version " + this.webXml.getVersion() + ", some elements may be skipped", this.getClass().getName());
        }
    }

    protected final void mergeFilters(WebXml theWebXml) {
        List<String> filterNames = WebXmlUtils.getFilterNames(theWebXml);
        int count = 0;
        for (String filterName : filterNames) {
            if (!WebXmlUtils.hasFilter(this.webXml, filterName)) {
                WebXmlUtils.addFilter(this.webXml, WebXmlUtils.getFilter(theWebXml, filterName));
            } else {
                List<String> filterInitParamNames = WebXmlUtils.getFilterInitParamNames(theWebXml, filterName);
                for (String paramName : filterInitParamNames) {
                    List<String> existingInitParams = WebXmlUtils.getFilterInitParamNames(this.webXml, filterName);
                    if (existingInitParams.contains(paramName)) continue;
                    String paramValue = WebXmlUtils.getFilterInitParam(theWebXml, filterName, paramName);
                    WebXmlUtils.addFilterInitParam(this.webXml, filterName, paramName, paramValue);
                }
            }
            List<FilterMapping> mappings = WebXmlUtils.getFilterMappingElements(theWebXml, filterName);
            for (FilterMapping mapping : mappings) {
                WebXmlUtils.addFilterMapping(this.webXml, mapping);
            }
            ++count;
        }
        this.getLogger().debug("Merged " + count + " filter definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }

    protected final void mergeServlets(WebXml theWebXml) throws CargoException {
        try {
            List<String> servletNames = WebXmlUtils.getServletNames(theWebXml);
            int count = 0;
            for (String servletName : servletNames) {
                if (!WebXmlUtils.hasServlet(this.webXml, servletName)) {
                    WebXmlUtils.addServlet(this.webXml, WebXmlUtils.getServlet(theWebXml, servletName));
                } else {
                    List<String> servletInitParamNames = WebXmlUtils.getServletInitParamNames(theWebXml, servletName);
                    for (String paramName : servletInitParamNames) {
                        String paramValue = WebXmlUtils.getServletInitParam(theWebXml, servletName, paramName);
                        WebXmlUtils.addServletInitParam(this.webXml, servletName, paramName, paramValue);
                    }
                    String roleName = WebXmlUtils.getServletRunAsRoleName(theWebXml, servletName);
                    if (roleName != null) {
                        WebXmlUtils.addServletRunAsRoleName(this.webXml, servletName, roleName);
                    }
                }
                List<String> servletMappings = WebXmlUtils.getServletMappings(theWebXml, servletName);
                for (String urlPattern : servletMappings) {
                    List<String> existingServletMappings = WebXmlUtils.getServletMappings(this.webXml, servletName);
                    if (existingServletMappings.contains(urlPattern)) continue;
                    WebXmlUtils.addServletMapping(this.webXml, servletName, urlPattern);
                }
                ++count;
            }
            this.getLogger().debug("Merged " + count + " servlet definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
        }
        catch (Exception ex) {
            throw new CargoException("Exception merging servlet definitions", (Throwable)ex);
        }
    }

    protected final void mergeSecurityRoles(WebXml theWebXml) {
        List<String> securityRoleNames = WebXmlUtils.getSecurityRoleNames(theWebXml);
        int count = 0;
        for (String securityRoleName : securityRoleNames) {
            if (WebXmlUtils.hasSecurityRole(this.webXml, securityRoleName)) continue;
            WebXmlUtils.addSecurityRole(this.webXml, securityRoleName);
        }
        if (count > 0) {
            this.getLogger().debug("Merged " + count + " security roles into the descriptor", this.getClass().getName());
        }
    }

    protected final void mergeMimeMappings(WebXml theWebXml) {
        int count = 0;
        List<Element> srcItems = this.webXml.getTags("mime-mapping");
        List<Element> targetItems = theWebXml.getTags("mime-mapping");
        for (Element targetItem : targetItems) {
            boolean foundItem = false;
            MimeMapping targetMimeMapping = (MimeMapping)targetItem;
            for (Element srcItem : srcItems) {
                MimeMapping srcMimeMapping = (MimeMapping)srcItem;
                if (!targetMimeMapping.getExtension().equals(srcMimeMapping.getExtension())) continue;
                foundItem = true;
                break;
            }
            if (foundItem) continue;
            MimeMapping mimeMappingElement = (MimeMapping)this.webXml.getDescriptorType().getTagByName("mime-mapping").create();
            mimeMappingElement.setExtension(targetMimeMapping.getExtension());
            mimeMappingElement.setMimeType(targetMimeMapping.getMimeType());
            this.webXml.addElement(mimeMappingElement.getTag(), mimeMappingElement, this.webXml.getRootElement());
            this.webXml.addTag(mimeMappingElement);
        }
        this.getLogger().debug("Merged " + count + " mime mapping definition" + (count != 1 ? "s " : " ") + "into the descriptor", this.getClass().getName());
    }
}

