/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.DescriptorElement;
import org.codehaus.cargo.module.DescriptorTag;
import org.codehaus.cargo.module.DescriptorType;
import org.codehaus.cargo.module.Identifier;
import org.codehaus.cargo.module.merge.DescriptorMerger;
import org.codehaus.cargo.module.merge.tagstrategy.MergeStrategy;
import org.codehaus.cargo.util.CargoException;
import org.jdom.Content;
import org.jdom.Element;

public class DescriptorMergerByTag
implements DescriptorMerger {
    public static final MergeStrategy IGNORE = new MergeStrategy(){

        @Override
        public int inBoth(Descriptor target, DescriptorElement left, DescriptorElement right) {
            return 0;
        }

        @Override
        public int inLeft(Descriptor target, DescriptorElement left) {
            return 0;
        }

        @Override
        public int inRight(Descriptor target, DescriptorElement right) {
            return 0;
        }
    };
    public static final MergeStrategy OVERWRITE = new MergeStrategy(){

        @Override
        public int inBoth(Descriptor target, DescriptorElement left, DescriptorElement right) {
            Element parent = left.getParentElement();
            parent.removeContent((Content)left);
            target.addElement(right.getTag(), right, parent);
            return 1;
        }

        @Override
        public int inLeft(Descriptor target, DescriptorElement left) {
            return 0;
        }

        @Override
        public int inRight(Descriptor target, DescriptorElement right) {
            target.addElement(right.getTag(), right, target.getRootElement());
            return 1;
        }
    };
    public static final MergeStrategy PRESERVE = new MergeStrategy(){

        @Override
        public int inBoth(Descriptor target, DescriptorElement left, DescriptorElement right) {
            return 0;
        }

        @Override
        public int inLeft(Descriptor target, DescriptorElement left) {
            return 0;
        }

        @Override
        public int inRight(Descriptor target, DescriptorElement right) {
            target.addElement(right.getTag(), right, target.getRootElement());
            return 1;
        }
    };
    private Descriptor baseDescriptor;
    private DescriptorType descriptorTagFactory;
    private Map<String, MergeStrategy> mapDescriptorTagToStrategy;
    private MergeStrategy defaultStrategyIfNoneSpecified = OVERWRITE;

    public DescriptorMergerByTag() {
        this.mapDescriptorTagToStrategy = new HashMap<String, MergeStrategy>();
    }

    public void setStrategy(String tag, MergeStrategy strategy) {
        this.mapDescriptorTagToStrategy.put(tag, strategy);
    }

    @Override
    public void init(Descriptor base) {
        this.baseDescriptor = base;
    }

    @Override
    public void merge(Descriptor other) {
        for (DescriptorTag tag : this.descriptorTagFactory.getAllTags()) {
            DescriptorElement rightElement;
            Identifier identifier = tag.getIdentifier();
            if (identifier != null) {
                MergeStrategy strategy = this.getMergeStrategy(tag.getTagName());
                Descriptor left = this.baseDescriptor;
                Descriptor right = other;
                ArrayList<Element> itemsL = new ArrayList<Element>(left.getTags(tag));
                ArrayList<Element> itemsR = new ArrayList<Element>(right.getTags(tag));
                try {
                    for (Element itemL : itemsL) {
                        DescriptorElement lElement = (DescriptorElement)itemL;
                        DescriptorElement rElement = (DescriptorElement)right.getTagByIdentifier(tag.getTagName(), identifier.getIdentifier(lElement));
                        if (rElement != null) {
                            strategy.inBoth(left, lElement, rElement);
                            continue;
                        }
                        strategy.inLeft(left, lElement);
                    }
                    Iterator iterator = itemsR.iterator();
                    while (iterator.hasNext()) {
                        Element itemR = (Element)iterator.next();
                        DescriptorElement rElement = (DescriptorElement)itemR;
                        DescriptorElement lElement = (DescriptorElement)left.getTagByIdentifier(tag.getTagName(), identifier.getIdentifier(rElement));
                        if (lElement != null) continue;
                        strategy.inRight(left, rElement);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new CargoException("Element Merging Exception", (Throwable)e);
                }
            }
            Descriptor left = this.baseDescriptor;
            Descriptor right = other;
            List<Element> itemsL = left.getTags(tag);
            ArrayList<Element> itemsR = new ArrayList<Element>(right.getTags(tag));
            if (tag.isMultipleAllowed()) {
                for (Element itemR : itemsR) {
                    rightElement = (DescriptorElement)itemR;
                    left.addElement(tag, rightElement, left.getRootElement());
                }
                continue;
            }
            MergeStrategy strategy = this.getMergeStrategy(tag.getTagName());
            DescriptorElement leftElement = itemsL.isEmpty() ? null : (DescriptorElement)itemsL.get(0);
            rightElement = itemsR.isEmpty() ? null : (DescriptorElement)((Object)itemsR.get(0));
            try {
                if (leftElement != null && rightElement != null) {
                    strategy.inBoth(left, leftElement, rightElement);
                    continue;
                }
                if (leftElement != null) {
                    strategy.inLeft(left, leftElement);
                    continue;
                }
                if (rightElement == null) continue;
                strategy.inRight(left, rightElement);
            }
            catch (Exception e) {
                throw new CargoException("Element Merging Exception", (Throwable)e);
            }
        }
    }

    protected MergeStrategy getMergeStrategy(String tag) {
        MergeStrategy strategy = this.mapDescriptorTagToStrategy.get(tag);
        if (strategy == null) {
            return this.defaultStrategyIfNoneSpecified;
        }
        return strategy;
    }

    public MergeStrategy getDefaultStrategyIfNoneSpecified() {
        return this.defaultStrategyIfNoneSpecified;
    }

    public void setDefaultStrategyIfNoneSpecified(MergeStrategy defaultStrategyIfNoneSpecified) {
        this.defaultStrategyIfNoneSpecified = defaultStrategyIfNoneSpecified;
    }

    public DescriptorType getDescriptorType() {
        return this.descriptorTagFactory;
    }

    public void setDescriptorType(DescriptorType descriptorTagFactory) {
        this.descriptorTagFactory = descriptorTagFactory;
    }
}

