/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util.internal.log;

import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Logger;

public abstract class AbstractLogger
implements Logger {
    private LogLevel level = LogLevel.INFO;

    public AbstractLogger(LogLevel level) {
        this.level = level;
    }

    public AbstractLogger() {
    }

    @Override
    public void setLevel(LogLevel level) {
        this.level = level;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void warn(String message, String category) {
        this.log(LogLevel.WARN, message, category);
    }

    @Override
    public void info(String message, String category) {
        this.log(LogLevel.INFO, message, category);
    }

    @Override
    public void debug(String message, String category) {
        this.log(LogLevel.DEBUG, message, category);
    }

    private void log(LogLevel level, String message, String category) {
        if (this.getLevel().compareTo(level) >= 0) {
            this.doLog(level, message, category);
        }
    }

    protected abstract void doLog(LogLevel var1, String var2, String var3);
}

