/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.util.Map;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.XmlFileBuilder;
import org.codehaus.cargo.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlFileBuilder
implements XmlFileBuilder {
    private XmlUtils xmlUtil;
    private String path;
    private Document document;

    public DefaultXmlFileBuilder(FileHandler fileHandler) {
        this.xmlUtil = new XmlUtils(fileHandler);
    }

    public DefaultXmlFileBuilder(FileHandler fileHandler, boolean namespaceAware) {
        this.xmlUtil = new XmlUtils(fileHandler, namespaceAware);
    }

    @Override
    public void setFile(String path) {
        this.path = path;
    }

    @Override
    public void insertElementsUnderXPath(String elementsToParse, String xpath) {
        Element parent = this.xmlUtil.selectElementMatchingXPath(xpath, this.document.getDocumentElement());
        StringBuilder nested = new StringBuilder();
        nested.append("<parent>");
        nested.append(elementsToParse);
        nested.append("</parent>");
        Element nestedElements = this.xmlUtil.parseIntoElement(nested.toString());
        NodeList children = nestedElements.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            Node clone = parent.getOwnerDocument().importNode(child, true);
            parent.appendChild(clone);
        }
    }

    @Override
    public void insertElementUnderXPath(Element elementToInsert, String xpath) {
        Element parent = this.xmlUtil.selectElementMatchingXPath(xpath, this.document.getDocumentElement());
        Node clone = parent.getOwnerDocument().importNode(elementToInsert, true);
        parent.appendChild(clone);
    }

    @Override
    public Document loadFile() {
        this.document = this.xmlUtil.loadXmlFromFile(this.path);
        return this.document;
    }

    @Override
    public void writeFile() {
        this.xmlUtil.saveXml(this.document, this.path);
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.xmlUtil.setNamespaces(namespaces);
    }
}

