/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.MissingXmlElementAppender;
import org.codehaus.cargo.util.XmlReplacement;
import org.codehaus.cargo.util.XmlUtils;
import org.codehaus.cargo.util.log.LoggedObject;
import org.codehaus.cargo.util.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultFileHandler
extends LoggedObject
implements FileHandler {
    public static final int FILE_BUFFER_SIZE = 262144;
    private static int uniqueNameCounter = -1;

    public static String sanitizeFilename(String filename, Logger logger) {
        String sanitizedFilename = filename.replace('\\', '/');
        if (sanitizedFilename.startsWith("/")) {
            if (logger != null) {
                logger.debug("File name [" + filename + "] has trailing slashes, removing for the sanitized file name", DefaultFileHandler.class.getName());
            }
            sanitizedFilename = sanitizedFilename.replaceAll("^\\/+", "");
        }
        if (sanitizedFilename.endsWith("/")) {
            if (logger != null) {
                logger.debug("File name [" + filename + "] has ending slashes, removing for the sanitized file name", DefaultFileHandler.class.getName());
            }
            sanitizedFilename = sanitizedFilename.replaceAll("\\/+$", "");
        }
        while (sanitizedFilename.contains("/../")) {
            if (logger != null) {
                logger.debug("File name [" + filename + "] has intermediate /../, replacing with single /", DefaultFileHandler.class.getName());
            }
            sanitizedFilename = sanitizedFilename.replace("/../", "/");
        }
        while (sanitizedFilename.contains("//")) {
            if (logger != null) {
                logger.debug("File name [" + filename + "] has intermediate //, replacing with single /", DefaultFileHandler.class.getName());
            }
            sanitizedFilename = sanitizedFilename.replace("//", "/");
        }
        return sanitizedFilename.trim();
    }

    @Override
    public void copyFile(String source, String target) {
        this.copyFile(source, target, false);
    }

    @Override
    public void copyFile(String source, String target, boolean overwrite) {
        File sourceFile = new File(source);
        if (!sourceFile.isFile()) {
            throw new CargoException("Source file [" + source + "] is not a file");
        }
        File targetFile = new File(target);
        if (targetFile.isFile() && !overwrite) {
            this.getLogger().debug("Skipping copy of existing binary file [" + target + "]", this.getClass().getName());
        } else {
            if (!targetFile.getParentFile().exists()) {
                this.mkdirs(targetFile.getParentFile().getAbsolutePath());
            }
            if (targetFile.isDirectory()) {
                targetFile = new File(this.append(target, this.getName(source)));
            }
            try (FileInputStream in = new FileInputStream(sourceFile);
                 FileOutputStream out = new FileOutputStream(targetFile);){
                this.copy(in, out);
            }
            catch (IOException e) {
                throw new CargoException("Failed to copy source file [" + source + "] to [" + targetFile + "]", e);
            }
            long size = targetFile.length();
            String unit = "bytes";
            if (size > 1024L) {
                size /= 1024L;
                unit = "KB";
            } else if (size > 1024L) {
                size /= 1024L;
                unit = "MB";
            }
            this.getLogger().debug("Copied binary file [" + source + "] to [" + target + "] (" + size + " " + unit + ")", this.getClass().getName());
        }
    }

    @Override
    public void copyFile(String source, String target, Map<String, String> replacements, Charset encoding) {
        try (BufferedReader fileReader = new BufferedReader(this.newReader(this.getInputStream(source), encoding));
             BufferedWriter out = new BufferedWriter(this.newWriter(target, encoding));){
            String line;
            while ((line = fileReader.readLine()) != null) {
                if (line.isEmpty()) {
                    out.newLine();
                    continue;
                }
                if (replacements != null) {
                    for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                        String replacementKey = "@" + replacement.getKey() + "@";
                        line = line.replace(replacementKey, replacement.getValue());
                    }
                }
                out.write(line);
                out.newLine();
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "] with replacements", e);
        }
        long size = this.getSize(target);
        String unit = "bytes";
        if (size > 1024L) {
            size /= 1024L;
            unit = "KB";
        } else if (size > 1024L) {
            size /= 1024L;
            unit = "MB";
        }
        this.getLogger().debug("Copied text file [" + source + "] to [" + target + "] (" + size + " " + unit + "), encoding " + encoding, this.getClass().getName());
    }

    @Override
    public void copyDirectory(String source, String target) {
        this.copyDirectory(source, target, null);
    }

    @Override
    public void copyDirectory(String source, String target, List<String> excludes) {
        File sourceDirectory = new File(source);
        if (!sourceDirectory.isDirectory()) {
            throw new CargoException("Source [" + source + "] is not a directory");
        }
        File targetDirectory = new File(target);
        if (!targetDirectory.isDirectory()) {
            targetDirectory.mkdirs();
        }
        if (!targetDirectory.isDirectory()) {
            throw new CargoException("Target directory [" + target + "] cannot be created");
        }
        for (File sourceDirectoryContent : sourceDirectory.listFiles()) {
            String sourcePath = sourceDirectoryContent.getAbsolutePath();
            String subtarget = this.append(target, sourceDirectoryContent.getName());
            boolean included = true;
            if (excludes != null) {
                for (String exclude : excludes) {
                    if (exclude.endsWith("/**")) {
                        if (!sourceDirectoryContent.isDirectory() || !sourceDirectoryContent.getName().equals(exclude.substring(0, exclude.length() - 3))) continue;
                        this.mkdirs(subtarget);
                        included = false;
                        break;
                    }
                    if (exclude.startsWith("**/")) {
                        if (!sourceDirectoryContent.isFile() || !sourceDirectoryContent.getName().endsWith(exclude.substring(3))) continue;
                        included = false;
                        break;
                    }
                    if (!exclude.contains("*") && !exclude.contains("/")) continue;
                    throw new CargoException("Unsupported exclusion filter: " + exclude);
                }
            }
            if (!included) continue;
            if (sourceDirectoryContent.isDirectory()) {
                ArrayList<String> updatedExcludes = null;
                if (excludes != null) {
                    for (String exclude : excludes) {
                        if (!exclude.startsWith("**/") || updatedExcludes != null) continue;
                        updatedExcludes = new ArrayList<String>();
                        updatedExcludes.add(exclude);
                    }
                }
                this.copyDirectory(sourcePath, subtarget, updatedExcludes);
                continue;
            }
            this.copyFile(sourcePath, subtarget);
        }
        this.getLogger().debug("Copied directory [" + source + "] to [" + target + "] with exclusions [" + excludes + "]", this.getClass().getName());
    }

    @Override
    public void copyDirectory(String source, String target, Map<String, String> replacements, Charset encoding) {
        File sourceDirectory = new File(source);
        if (!sourceDirectory.isDirectory()) {
            throw new CargoException("Source [" + source + "] is not a directory");
        }
        File targetDirectory = new File(target);
        if (!targetDirectory.isDirectory()) {
            targetDirectory.mkdirs();
        }
        if (!targetDirectory.isDirectory()) {
            throw new CargoException("Target directory [" + target + "] cannot be created");
        }
        for (File sourceDirectoryContent : sourceDirectory.listFiles()) {
            File targetFile = new File(targetDirectory, sourceDirectoryContent.getName());
            if (sourceDirectoryContent.isFile()) {
                if (replacements == null) {
                    this.copyFile(sourceDirectoryContent.getAbsolutePath(), targetFile.getAbsolutePath());
                    continue;
                }
                this.copyFile(sourceDirectoryContent.getAbsolutePath(), targetFile.getAbsolutePath(), replacements, encoding);
                continue;
            }
            this.copyDirectory(sourceDirectoryContent.getAbsolutePath(), targetFile.getAbsolutePath(), replacements, encoding);
        }
        this.getLogger().debug("Copied directory [" + source + "] to [" + target + "] with replacements [" + replacements + "]", this.getClass().getName());
    }

    @Override
    public void explode(String war, String exploded) {
        if (this.exists(exploded)) {
            this.delete(exploded);
        }
        Path explodedPath = new File(exploded).toPath();
        try (JarFile archive = new JarFile(new File(war).getAbsoluteFile());){
            Enumeration<JarEntry> e = archive.entries();
            while (e.hasMoreElements()) {
                JarEntry j = e.nextElement();
                String dst = this.append(exploded, DefaultFileHandler.sanitizeFilename(j.getName(), this.getLogger()));
                if (j.isDirectory()) {
                    this.mkdirs(dst);
                    continue;
                }
                this.mkdirs(this.getParent(dst));
                InputStream in = archive.getInputStream(j);
                try (FileOutputStream out = new FileOutputStream(dst);){
                    this.copy(in, out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (IOException e) {
            try {
                this.delete(exploded);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CargoException("Failed to extract file [" + war + "] to [" + exploded + "]", e);
        }
    }

    @Override
    public String createDirectory(String parentDir, String name) {
        File dir = new File(parentDir, name);
        this.mkdirs(dir.getAbsolutePath());
        if (!dir.isDirectory() || !dir.exists()) {
            throw new CargoException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir.getPath();
    }

    @Override
    public void copy(InputStream in, OutputStream out, int bufSize) {
        try {
            int length;
            byte[] buf = new byte[bufSize];
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy input stream [" + in.toString() + "] to output stream [" + out.toString() + "]", e);
        }
    }

    @Override
    public void copy(InputStream in, OutputStream out) {
        this.copy(in, out, 262144);
    }

    @Override
    public void replaceInFile(String file, Map<String, String> replacements, Charset encoding) throws CargoException {
        this.replaceInFile(file, replacements, encoding, false);
    }

    @Override
    public void replaceInFile(String file, Map<String, String> replacements, Charset encoding, boolean ignoreNonExistingProperties) throws CargoException {
        String fileContents = this.readTextFile(file, encoding);
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (!fileContents.contains(replacement.getKey())) {
                String message = "File " + file + " does not contain replacement key " + replacement.getKey();
                if (ignoreNonExistingProperties) {
                    this.getLogger().debug(message, this.getClass().getName());
                    continue;
                }
                throw new CargoException(message);
            }
            fileContents = fileContents.replace(replacement.getKey(), replacement.getValue());
        }
        this.writeTextFile(file, fileContents, encoding);
    }

    @Override
    public void replaceInXmlFile(XmlReplacement ... xmlReplacements) throws CargoException {
        HashMap replacements = new HashMap();
        for (XmlReplacement xmlReplacement : xmlReplacements) {
            HashMap<FileHandler.XmlReplacementDetails, String> replacementDetails = (HashMap<FileHandler.XmlReplacementDetails, String>)replacements.get(xmlReplacement.getFile());
            if (replacementDetails == null) {
                replacementDetails = new HashMap<FileHandler.XmlReplacementDetails, String>();
                replacements.put(xmlReplacement.getFile(), replacementDetails);
            }
            FileHandler.XmlReplacementDetails xmlReplacementDetails = new FileHandler.XmlReplacementDetails(xmlReplacement.getXpathExpression(), xmlReplacement.getAttributeName(), xmlReplacement.getReplacementBehavior());
            replacementDetails.put(xmlReplacementDetails, xmlReplacement.getValue());
        }
        for (Map.Entry entry : replacements.entrySet()) {
            this.replaceInXmlFile((String)entry.getKey(), (Map)entry.getValue());
        }
    }

    private void replaceInXmlFile(String file, Map<FileHandler.XmlReplacementDetails, String> replacements) throws CargoException {
        XmlUtils domUtils = new XmlUtils(this);
        Document doc = domUtils.loadXmlFromFile(file);
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            block7: for (Map.Entry<FileHandler.XmlReplacementDetails, String> replacement : replacements.entrySet()) {
                String expression = replacement.getKey().getXpathExpression();
                String attributeName = replacement.getKey().getAttributeName();
                XPathExpression xPathExpr = xPath.compile(expression);
                Node node = (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
                if (node == null) {
                    String message = "Node " + expression + " not found in file " + file;
                    XmlReplacement.ReplacementBehavior replacementBehavior = replacement.getKey().getReplacementBehavior();
                    switch (replacementBehavior) {
                        case IGNORE_IF_NON_EXISTING: {
                            this.getLogger().debug(message, this.getClass().getName());
                            continue block7;
                        }
                        case THROW_EXCEPTION: {
                            throw new CargoException(message);
                        }
                        case ADD_MISSING_NODES: {
                            node = new MissingXmlElementAppender(doc, expression).append();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown ReplacementBehavior [" + (Object)((Object)replacementBehavior) + "]");
                        }
                    }
                }
                if (attributeName != null) {
                    Node attribute = node.getAttributes().getNamedItem(attributeName);
                    if (attribute == null) {
                        ((Element)node).setAttribute(attributeName, replacement.getValue());
                        continue;
                    }
                    attribute.setNodeValue(replacement.getValue());
                    continue;
                }
                node.setTextContent(replacement.getValue());
            }
        }
        catch (Exception e) {
            throw new CargoException("Cannot modify XML document " + file, e);
        }
        domUtils.saveXml(doc, file);
        this.getLogger().debug("Performed XML replacements in [" + file + "]", this.getClass().getName());
    }

    @Override
    public String getTmpPath(String name) {
        return new File(new File(System.getProperty("java.io.tmpdir"), "cargo"), name).getPath();
    }

    @Override
    public synchronized String createUniqueTmpDirectory() {
        File tmpDir;
        if (uniqueNameCounter == -1) {
            uniqueNameCounter = new Random().nextInt() & 0xFFFF;
        }
        while ((tmpDir = new File(this.getTmpPath(Integer.toString(++uniqueNameCounter)))).exists()) {
        }
        tmpDir.deleteOnExit();
        this.mkdirs(tmpDir.getAbsolutePath());
        this.getLogger().debug("Created unique temporary directory [" + tmpDir + "]", this.getClass().getName());
        return tmpDir.getPath();
    }

    @Override
    public void delete(String path) {
        File pathAsFile = new File(path);
        if (pathAsFile.isDirectory()) {
            File[] children;
            for (File element : children = pathAsFile.listFiles()) {
                this.delete(element.getPath());
            }
        }
        pathAsFile.delete();
        this.getLogger().debug("Deleted file [" + path + "]", this.getClass().getName());
    }

    @Override
    public long getSize(String file) {
        File fileObject = new File(file).getAbsoluteFile();
        if (!fileObject.isFile()) {
            throw new CargoException("File [" + file + "] is not a file");
        }
        return fileObject.length();
    }

    @Override
    public InputStream getInputStream(String file) {
        FileInputStream is;
        try {
            is = new FileInputStream(new File(file).getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to find file [" + file + "]", e);
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream(String file) {
        FileOutputStream os;
        String parent = this.getParent(file);
        if (parent != null) {
            this.mkdirs(parent);
        }
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to open output stream for file [" + file + "]", e);
        }
        return os;
    }

    @Override
    public String append(String path, String suffixToAppend) {
        String result = !path.endsWith("/") && !path.endsWith("\\") ? (path.contains("\\") ? path + "\\" + suffixToAppend : path + "/" + suffixToAppend) : path + suffixToAppend;
        return result;
    }

    @Override
    public void mkdirs(String path) {
        File pathFile = new File(path);
        boolean success = false;
        for (int i = 0; i < 3 && !success; ++i) {
            if (pathFile.isFile()) {
                throw new CargoException("Path [" + pathFile + "] is a file and not a directory");
            }
            if (pathFile.isDirectory()) {
                success = true;
                this.getLogger().debug("Directory [" + pathFile + "] exists", this.getClass().getName());
                continue;
            }
            this.getLogger().debug("Creating directory [" + pathFile + "] and parents", this.getClass().getName());
            success = pathFile.mkdirs();
        }
        if (!success) {
            throw new CargoException("Failed to create folders for path [" + path + "]");
        }
    }

    @Override
    public String getParent(String path) {
        return new File(path).getParent();
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public void createFile(String file) {
        String parent = this.getParent(file);
        if (!this.isDirectory(parent)) {
            this.mkdirs(parent);
        }
        try {
            new File(file).createNewFile();
        }
        catch (IOException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    @Override
    public boolean isDirectoryEmpty(String dir) {
        File directory = new File(dir);
        if (!directory.isDirectory()) {
            throw new CargoException("Path [" + dir + "] does not exist or is not a directory");
        }
        return directory.list().length == 0;
    }

    @Override
    public String getName(String file) {
        return new File(file).getName();
    }

    @Override
    public String getURL(String path) {
        URL result;
        try {
            result = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to return URL for [" + path + "]", e);
        }
        return result.toString();
    }

    @Override
    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public String[] getChildren(String directory) {
        return this.getChildren(directory, null);
    }

    @Override
    public String[] getChildren(String directory, List<String> filters) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = new File(directory).listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (filters != null) {
                for (String filter : filters) {
                    if (filter.contains("/")) {
                        throw new CargoException("Unsupported file filter: " + filter);
                    }
                    if (filter.startsWith("*")) {
                        if (!files[i].getName().endsWith(filter.substring(1))) continue;
                        results.add(files[i].getPath());
                        continue;
                    }
                    if (filter.contains("*")) {
                        throw new CargoException("Unsupported file filter: " + filter);
                    }
                    if (!files[i].getName().equals(filter)) continue;
                    results.add(files[i].getPath());
                }
                continue;
            }
            results.add(files[i].getPath());
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public String getAbsolutePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir"), file.getPath());
        }
        return file.getAbsolutePath();
    }

    @Override
    public String readTextFile(String file, Charset encoding) {
        String string;
        BufferedReader in = new BufferedReader(this.newReader(this.getInputStream(file), encoding));
        try {
            String str;
            StringBuilder out = new StringBuilder();
            while ((str = in.readLine()) != null) {
                if (out.length() > 0) {
                    out.append(System.getProperty("line.separator"));
                }
                out.append(str);
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CargoException("Failed to read text from file: " + file, e);
            }
        }
        in.close();
        return string;
    }

    @Override
    public void writeTextFile(String file, String content, Charset encoding) {
        try (Writer writer = this.newWriter(file, encoding);){
            writer.write(content);
        }
        catch (IOException e) {
            throw new CargoException("Cannot write file" + file, e);
        }
        this.getLogger().debug("Wrote text file [" + file + "], encoding " + encoding, this.getClass().getName());
    }

    private Reader newReader(InputStream is, Charset encoding) throws IOException {
        if (encoding == null) {
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }
        return new InputStreamReader(is, encoding);
    }

    private Writer newWriter(String file, Charset encoding) throws IOException {
        String parent = this.getParent(file);
        if (!this.isDirectory(parent)) {
            this.mkdirs(parent);
        }
        if (encoding == null) {
            return new OutputStreamWriter(this.getOutputStream(file), StandardCharsets.UTF_8);
        }
        return new OutputStreamWriter(this.getOutputStream(file), encoding);
    }
}

