/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.ElementNotFoundException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.NamespaceContextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class XmlUtils {
    private FileHandler fileHandler;
    private DocumentBuilder builder;
    private XPath xPath;
    private NamespaceContextImpl namespaceContext;
    private boolean namespaceAware;

    public XmlUtils() {
        this(new DefaultFileHandler());
    }

    public XmlUtils(boolean namespaceAware) {
        this(new DefaultFileHandler(), namespaceAware);
    }

    public XmlUtils(FileHandler fileHandler) {
        this(fileHandler, false);
    }

    public XmlUtils(FileHandler fileHandler, boolean namespaceAware) {
        this.fileHandler = fileHandler;
        this.namespaceContext = new NamespaceContextImpl();
        this.namespaceAware = namespaceAware;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        this.xPath = xPathFactory.newXPath();
        this.xPath.setNamespaceContext(this.namespaceContext);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(namespaceAware);
        try {
            domFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            domFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (AbstractMethodError | ParserConfigurationException throwable) {
            // empty catch block
        }
        try {
            this.builder = domFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new CargoException("Cannot create XML DOM builder", e);
        }
    }

    public List<Element> selectElementsMatchingXPath(String xpath, Element toSearch) {
        NodeList nodelist;
        try {
            String xpathWithoutNamespace = xpath;
            Map<String, String> namespaces = this.namespaceContext.getNamespaces();
            if (namespaces != null && !namespaces.isEmpty() && !this.namespaceAware) {
                for (Map.Entry<String, String> namespace : namespaces.entrySet()) {
                    String key = namespace.getKey() + ":";
                    while (xpathWithoutNamespace.contains(key)) {
                        xpathWithoutNamespace = xpathWithoutNamespace.replace(key, "");
                    }
                }
            }
            XPathExpression xPathExpr = this.xPath.compile(xpathWithoutNamespace);
            nodelist = (NodeList)xPathExpr.evaluate(toSearch, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new CargoException("Cannot evaluate XPath: " + xpath, e);
        }
        ArrayList<Element> result = new ArrayList<Element>(nodelist.getLength());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            result.add((Element)nodelist.item(i));
        }
        return result;
    }

    public Element selectElementMatchingXPath(String xpath, Element toSearch) {
        List<Element> results = this.selectElementsMatchingXPath(xpath, toSearch);
        if (results.isEmpty()) {
            throw new ElementNotFoundException(xpath, toSearch);
        }
        Element match = results.get(0);
        return match;
    }

    public Document loadXmlFromFile(String sourceFile) {
        Document document;
        block10: {
            if (!this.getFileHandler().exists(sourceFile)) {
                throw new CargoException("Cannot find file: " + sourceFile);
            }
            if (this.getFileHandler().isDirectory(sourceFile)) {
                throw new CargoException("The destination is a directory: " + sourceFile);
            }
            InputStream is = this.getFileHandler().getInputStream(sourceFile);
            try {
                document = this.builder.parse(is);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CargoException("Cannot parse XML file " + sourceFile, e);
                }
            }
            is.close();
        }
        return document;
    }

    public void saveXml(Document document, String filename) {
        try (OutputStream os = this.getFileHandler().getOutputStream(filename);){
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(os));
        }
        catch (Exception e) {
            throw new CargoException("Cannot modify XML file " + filename, e);
        }
    }

    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaceContext.setNamespaces(namespaces);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaceContext.getNamespaces();
    }

    public Element parseIntoElement(String elementToParse) {
        try {
            Document parsed = this.builder.parse(new ByteArrayInputStream(elementToParse.getBytes(StandardCharsets.UTF_8)));
            return parsed.getDocumentElement();
        }
        catch (Exception e) {
            throw new CargoException("Could not parse element: " + elementToParse);
        }
    }

    public Document createDocument() {
        return this.builder.newDocument();
    }

    public String toString(Element node) {
        DOMImplementationLS implementation = (DOMImplementationLS)((Object)node.getOwnerDocument().getImplementation());
        LSSerializer serializer = implementation.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", true);
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(node);
    }
}

