/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.geronimo;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.geronimo.deployable.GeronimoDeployable;
import org.codehaus.cargo.container.geronimo.internal.GeronimoUtils;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;
import org.codehaus.cargo.util.AntUtils;

public class GeronimoInstalledLocalDeployer
extends AbstractInstalledLocalDeployer {
    private AntUtils antUtils = new AntUtils();
    private GeronimoUtils geronimoUtils;

    public GeronimoInstalledLocalDeployer(InstalledLocalContainer container) {
        super((LocalContainer)container);
        this.geronimoUtils = new GeronimoUtils((Configuration)container.getConfiguration());
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected InstalledLocalContainer getInstalledContainer() {
        return (InstalledLocalContainer)super.getContainer();
    }

    public void deploy(Deployable deployable) {
        Java java = this.createAdminDeployerJava("deploy");
        this.addPathArgument(java, deployable);
        String deployableId = this.getModuleId(deployable);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to deploy [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to deploy [" + deployableId + "]", (Throwable)e);
        }
    }

    public void distribute(Deployable deployable) {
        Java java = this.createDeployerJava("distribute");
        this.addPathArgument(java, deployable);
        String deployableId = this.getModuleId(deployable);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to distribute [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to distribute [" + deployableId + "]", (Throwable)e);
        }
    }

    public void start(Deployable deployable) {
        this.start(this.getModuleId(deployable));
    }

    public void start(String deployableId) {
        if (deployableId == null) {
            throw new ContainerException("Failed: deployable ID cannot be null.");
        }
        Java java = this.createAdminDeployerJava("start");
        java.createArg().setValue(deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to start [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to start [" + deployableId + "]", (Throwable)e);
        }
    }

    public void stop(Deployable deployable) {
        this.stop(this.getModuleId(deployable));
    }

    public void stop(String deployableId) {
        if (deployableId == null) {
            throw new ContainerException("Failed: deployable ID cannot be null.");
        }
        Java java = this.createAdminDeployerJava("stop");
        java.createArg().setValue(deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to stop [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to stop [" + deployableId + "]", (Throwable)e);
        }
    }

    public void undeploy(Deployable deployable) {
        this.undeploy(this.getModuleId(deployable));
    }

    public void undeploy(String deployableId) {
        if (deployableId == null) {
            throw new ContainerException("Failed: deployable ID cannot be null.");
        }
        Java java = this.createAdminDeployerJava("undeploy");
        java.createArg().setValue(deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to undeploy [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to undeploy [" + deployableId + "]", (Throwable)e);
        }
    }

    public void redeploy(Deployable deployable) {
        Java java = this.createAdminDeployerJava("redeploy");
        this.addPathArgument(java, deployable);
        String deployableId = this.getModuleId(deployable);
        this.addModuleIdArgument(java, deployableId);
        try {
            int retval = java.executeJava();
            if (retval != 0) {
                throw new ContainerException("Failed to redeploy [" + deployableId + "]");
            }
        }
        catch (BuildException e) {
            throw new ContainerException("Failed to redeploy [" + deployableId + "]", (Throwable)e);
        }
    }

    private Java createJava() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), ((Object)((Object)this)).getClass().getName()));
        this.addExtraClasspath(java);
        this.addSystemProperties(java);
        this.addJvmArgs(java);
        return java;
    }

    private Java createDeployerJava(String action) {
        Java java = this.createJava();
        java.setJar(new File(this.getInstalledContainer().getHome(), "bin/deployer.jar"));
        java.createArg().setValue(action);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getLogger(), ((Object)((Object)this)).getClass().getName()));
        return java;
    }

    private Java createAdminDeployerJava(String action) {
        Java java = this.createJava();
        java.createArg().setValue("--user");
        java.createArg().setValue(this.getContainer().getConfiguration().getPropertyValue("cargo.remote.username"));
        java.createArg().setValue("--password");
        java.createArg().setValue(this.getContainer().getConfiguration().getPropertyValue("cargo.remote.password"));
        if (this.geronimoUtils.isGeronimoStarted()) {
            java.createArg().setValue("--host");
            java.createArg().setValue(this.getContainer().getConfiguration().getPropertyValue("cargo.hostname"));
            java.createArg().setValue("--port");
            java.createArg().setValue(this.getContainer().getConfiguration().getPropertyValue("cargo.rmi.port"));
        } else {
            java.createArg().setValue("--offline");
        }
        java.setJar(new File(this.getInstalledContainer().getHome(), "bin/deployer.jar"));
        java.createArg().setValue(action);
        return java;
    }

    private void addPathArgument(Java java, Deployable deployable) {
        GeronimoDeployable geronimoDeployable;
        String deployableFile = deployable.getFile();
        if (deployable instanceof WAR) {
            WAR warDeployable = (WAR)deployable;
            if (warDeployable.isExpandedWar()) {
                throw new ContainerException("The Apache Geronimo container does not support expanded WARs");
            }
            if (warDeployable.getContext() != null) {
                File toFile = new File(this.getContainer().getConfiguration().getHome(), "var/temp/" + warDeployable.getContext() + ".war");
                Copy copyWar = (Copy)this.getAntUtils().createAntTask("copy");
                copyWar.setFile(new File(deployableFile));
                copyWar.setTofile(toFile);
                copyWar.setOverwrite(true);
                copyWar.execute();
                deployableFile = toFile.getPath();
            }
        }
        java.createArg().setValue(deployableFile);
        if (deployable instanceof GeronimoDeployable && (geronimoDeployable = (GeronimoDeployable)deployable).getPlan() != null) {
            File planFile = new File(geronimoDeployable.getPlan());
            if (!planFile.exists()) {
                this.getLogger().warn("Cannot locate deployment plan [" + planFile.getPath() + "]. Will attempt to deploy without it.", ((Object)((Object)this)).getClass().getName());
            } else {
                java.createArg().setValue(geronimoDeployable.getPlan());
            }
        }
    }

    private void addModuleIdArgument(Java java, String moduleId) {
        if (moduleId != null) {
            java.createArg().setValue(moduleId);
        }
    }

    private void addSystemProperties(Java java) {
        for (String key : this.getInstalledContainer().getSystemProperties().keySet()) {
            java.addSysproperty(this.getAntUtils().createSysProperty(key, (String)this.getInstalledContainer().getSystemProperties().get(key)));
        }
    }

    private void addJvmArgs(Java javacommand) {
        String jvmargs = this.getContainer().getConfiguration().getPropertyValue("cargo.jvmargs");
        if (jvmargs != null) {
            jvmargs = jvmargs.replace("\n", " ");
            jvmargs = jvmargs.replace("\r", " ");
            jvmargs = jvmargs.replace("\t", " ");
            javacommand.createJvmarg().setLine(jvmargs);
        }
    }

    private void addExtraClasspath(Java javaCommand) {
        Path classpath = javaCommand.createClasspath();
        if (this.getInstalledContainer().getExtraClasspath() != null) {
            Path path = new Path(this.getAntUtils().createProject());
            for (int i = 0; i < this.getInstalledContainer().getExtraClasspath().length; ++i) {
                Path pathElement = new Path(this.getAntUtils().createProject(), this.getInstalledContainer().getExtraClasspath()[i]);
                path.addExisting(pathElement);
                this.getLogger().debug("Adding [" + pathElement + "] to execution classpath", ((Object)((Object)this)).getClass().getName());
            }
            classpath.addExisting(path);
        }
    }

    private String getModuleId(Deployable deployable) {
        File planFile;
        GeronimoDeployable geronimoDeployable;
        int lastDot;
        String moduleId = null;
        String archiveFile = deployable.getFile();
        if (this.getFileHandler().exists(archiveFile) && (lastDot = (moduleId = new File(archiveFile).getName()).lastIndexOf(46)) != -1) {
            moduleId = moduleId.substring(0, lastDot);
        }
        if (deployable instanceof WAR) {
            WAR warDeployable = (WAR)deployable;
            if (warDeployable.getContext() != null) {
                moduleId = warDeployable.getContext();
            }
        } else if (!(deployable instanceof GeronimoDeployable) || (geronimoDeployable = (GeronimoDeployable)deployable).getPlan() == null || (planFile = new File(geronimoDeployable.getPlan())).exists() || archiveFile != null) {
            // empty if block
        }
        this.getLogger().debug("Computed module id [" + moduleId + "] for deployable [" + deployable.getFile() + "]", ((Object)((Object)this)).getClass().getName());
        return moduleId;
    }
}

