/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.glassfish;

import java.io.File;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.glassfish.GlassFish3xContainerCapability;
import org.codehaus.cargo.container.glassfish.internal.AbstractGlassFishInstalledLocalContainer;
import org.codehaus.cargo.container.internal.AntContainerExecutorThread;
import org.codehaus.cargo.util.CargoException;

public class GlassFish3xInstalledLocalContainer
extends AbstractGlassFishInstalledLocalContainer {
    private static final ContainerCapability CAPABILITY = new GlassFish3xContainerCapability();

    public GlassFish3xInstalledLocalContainer(LocalConfiguration localConfiguration) {
        super(localConfiguration);
    }

    public void invokeAsAdmin(boolean async, Java java, String[] args) {
        String home = this.getHome();
        if (home == null || !this.getFileHandler().isDirectory(home)) {
            throw new CargoException("GlassFish home directory is not set");
        }
        File adminCli = new File(home, "glassfish/modules/admin-cli.jar");
        if (!adminCli.isFile()) {
            throw new CargoException("Cannot find the GlassFish admin CLI JAR: " + adminCli.getName());
        }
        java.setJar(adminCli);
        for (String arg : args) {
            java.createArg().setValue(arg);
        }
        if (async) {
            AntContainerExecutorThread glassFishRunner = new AntContainerExecutorThread(java);
            glassFishRunner.start();
        } else {
            int exitCode = java.executeJava();
            if (exitCode != 0 && exitCode != 1) {
                throw new CargoException("Command " + args[0] + " failed: asadmin exited " + exitCode);
            }
        }
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    public String getId() {
        return "glassfish3x";
    }

    public String getName() {
        return "GlassFish 3.x";
    }
}

