/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.glassfish;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.glassfish.GlassFishStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.glassfish.internal.AbstractGlassFishInstalledLocalContainer;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;

public class GlassFishStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new GlassFishStandaloneLocalConfigurationCapability();

    public GlassFishStandaloneLocalConfiguration(String home) {
        super(home);
        this.setProperty("cargo.remote.username", "admin");
        this.setProperty("cargo.remote.password", "adminadmin");
        this.setProperty("cargo.hostname", "localhost");
        this.setProperty("cargo.glassfish.adminPort", "4848");
        this.setProperty("cargo.glassfish.jms.port", "7676");
        this.setProperty("cargo.glassfish.orb.listener.port", "3700");
        this.setProperty("cargo.glassfish.http.ssl.port", "8181");
        this.setProperty("cargo.glassfish.orb.ssl.port", "3820");
        this.setProperty("cargo.glassfish.orb.mutualauth.port", "3920");
        this.setProperty("cargo.glassfish.domain.jmxPort", "8686");
        this.setProperty("cargo.glassfish.domain.name", "cargo-domain");
    }

    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    File getPasswordFile() {
        String password = this.getPropertyValue("cargo.remote.password");
        if (password == null) {
            password = "";
        }
        try {
            File f = new File(this.getHome(), "password.properties");
            if (!f.exists()) {
                this.getFileHandler().mkdirs(this.getHome());
                FileWriter w = new FileWriter(f);
                w.write("AS_ADMIN_PASSWORD=" + password + "\n");
                w.write("AS_ADMIN_ADMINPASSWORD=" + password + "\n");
                w.close();
            }
            return f;
        }
        catch (IOException e) {
            throw new CargoException("Failed to create a password file", (Throwable)e);
        }
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        DefaultFileHandler fileHandler = new DefaultFileHandler();
        fileHandler.delete(this.getHome());
        ((AbstractGlassFishInstalledLocalContainer)container).invokeAsAdmin(false, new String[]{"create-domain", "--interactive=false", "--adminport", this.getPropertyValue("cargo.glassfish.adminPort"), "--user", this.getPropertyValue("cargo.remote.username"), "--passwordfile", this.getPasswordFile().getAbsolutePath(), "--instanceport", this.getPropertyValue("cargo.servlet.port"), "--domainproperties", this.getPropertyValueString("cargo.glassfish.jms.port") + ':' + this.getPropertyValueString("cargo.glassfish.orb.listener.port") + ':' + this.getPropertyValueString("cargo.glassfish.orb.ssl.port") + ':' + this.getPropertyValueString("cargo.glassfish.http.ssl.port") + ':' + this.getPropertyValueString("cargo.glassfish.orb.mutualauth.port") + ':' + this.getPropertyValueString("cargo.glassfish.domain.jmxPort"), "--domaindir", this.getHome(), this.getPropertyValue("cargo.glassfish.domain.name")});
        String cpcWar = this.getFileHandler().append(this.getHome(), "cargocpc.war");
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(cpcWar));
        this.getDeployables().add(new WAR(cpcWar));
    }

    private String getPropertyValueString(String key) {
        String value = this.getPropertyValue(key);
        return key.substring("cargo.glassfish.".length()) + '=' + value;
    }
}

