/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jboss.JBossDeployer;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfigurationCapability;

public class JBossExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    public JBossExistingLocalConfiguration(File dir) {
        super(dir);
        this.setProperty("cargo.jboss.rmi.port", "1299");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        File deployDir = new File(this.getHome().getPath(), "deploy");
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        JBossDeployer deployer = new JBossDeployer(container);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
    }

    public void verifyProperties() {
    }

    public ConfigurationCapability getCapability() {
        return new AbstractStandaloneLocalConfigurationCapability(){

            protected Map getPropertySupportMap() {
                return new HashMap();
            }
        };
    }

    public String toString() {
        return "JBoss Existing Configuration";
    }
}

