/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.jetty.internal.JettyExecutorThread;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.AbstractLocalContainer;
import org.codehaus.cargo.container.spi.configuration.ContainerConfiguration;

public class Jetty4xEmbeddedLocalContainer
extends AbstractLocalContainer {
    public static final String ID = "jetty4xEmbedded";
    private ContainerCapability capability = new ServletContainerCapability();
    private Object server;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public Jetty4xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public Object getServer() {
        return this.server;
    }

    private synchronized void createServerObject() {
        if (this.server == null) {
            try {
                this.server = Class.forName("org.mortbay.jetty.Server").newInstance();
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create Jetty Server instance", (Throwable)e);
            }
        }
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }

    public final void doStart(Java java) throws Exception {
        this.createServerObject();
        this.getConfiguration().configure((LocalContainer)this);
        Class<?> listenerClass = Class.forName("org.mortbay.http.SocketListener");
        Object listener = listenerClass.newInstance();
        listenerClass.getMethod("setPort", Integer.TYPE).invoke(listener, new Integer(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        this.getServer().getClass().getMethod("addListener", Class.forName("org.mortbay.http.HttpListener")).invoke(this.getServer(), listener);
        this.setSecurityRealm();
        Iterator it = this.getConfiguration().getDeployables().iterator();
        while (it.hasNext()) {
            Deployable deployable = (Deployable)it.next();
            if (deployable.getType() == DeployableType.WAR) {
                this.getServer().getClass().getMethod("addWebApplication", class$java$lang$String == null ? Jetty4xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? Jetty4xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String).invoke(this.getServer(), "/" + ((WAR)deployable).getContext(), deployable.getFile().getPath());
                continue;
            }
            throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
        }
        this.getServer().getClass().getMethod("addWebApplication", class$java$lang$String == null ? (class$java$lang$String = Jetty4xEmbeddedLocalContainer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Jetty4xEmbeddedLocalContainer.class$("java.lang.String")) : class$java$lang$String).invoke(this.getServer(), "/cargocpc", new File(this.getConfiguration().getHome().getPath(), "cargocpc.war").getPath());
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), true);
        jettyRunner.start();
    }

    private void setSecurityRealm() throws Exception {
        if (this.getConfiguration().getPropertyValue("cargo.servlet.users") != null) {
            Class<?> realmClass = Class.forName("org.mortbay.http.HashUserRealm");
            Object realm = realmClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Jetty4xEmbeddedLocalContainer.class$("java.lang.String")) : class$java$lang$String).newInstance("Cargo Test Realm");
            Iterator users = User.parseUsers((String)this.getConfiguration().getPropertyValue("cargo.servlet.users")).iterator();
            while (users.hasNext()) {
                User user = (User)users.next();
                realm.getClass().getMethod("put", class$java$lang$Object == null ? Jetty4xEmbeddedLocalContainer.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$Object == null ? Jetty4xEmbeddedLocalContainer.class$("java.lang.Object") : class$java$lang$Object).invoke(realm, user.getName(), user.getPassword());
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    realm.getClass().getMethod("addUserToRole", class$java$lang$String == null ? Jetty4xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String, class$java$lang$String == null ? Jetty4xEmbeddedLocalContainer.class$("java.lang.String") : class$java$lang$String).invoke(realm, user.getName(), role);
                }
            }
            this.getServer().getClass().getMethod("addRealm", Class.forName("org.mortbay.http.UserRealm")).invoke(this.getServer(), realm);
        }
    }

    public final void doStop(Java java) throws Exception {
        this.createServerObject();
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), false);
        jettyRunner.start();
    }

    public final String getId() {
        return ID;
    }

    public String getName() {
        return "Jetty 4.x Embedded";
    }

    protected void verify() {
        ((ContainerConfiguration)this.getConfiguration()).verifyProperties();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

