/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.jetty.Jetty4xEmbeddedLocalContainer;
import org.codehaus.cargo.container.spi.deployer.DeployerWatchdog;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class JettyDeployer
extends MonitoredObject
implements Deployer {
    private LocalContainer container;
    static /* synthetic */ Class class$java$lang$String;

    public JettyDeployer(LocalContainer container) {
        this.container = container;
        this.setMonitor(container.getMonitor());
    }

    protected Container getContainer() {
        return this.container;
    }

    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        this.deploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setMonitor(this.getMonitor());
        watchdog.watchForAvailability();
    }

    public void deploy(Deployable deployable) {
        this.getMonitor().info("Deploying [" + deployable.getFile().getPath() + "]", ((Object)((Object)this)).getClass().getName());
        if (deployable.getType() == DeployableType.WAR) {
            try {
                Jetty4xEmbeddedLocalContainer container = (Jetty4xEmbeddedLocalContainer)this.getContainer();
                Object context = container.getServer().getClass().getMethod("addWebApplication", class$java$lang$String == null ? (class$java$lang$String = JettyDeployer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JettyDeployer.class$("java.lang.String")) : class$java$lang$String).invoke(container.getServer(), "/" + ((WAR)deployable).getContext(), deployable.getFile().getPath());
                Class<?> wc = Class.forName("org.mortbay.jetty.servlet.WebApplicationContext");
                wc.getMethod("stop", null).invoke(context, null);
                wc.getMethod("start", null).invoke(context, null);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", (Throwable)e);
            }
        } else {
            throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
        }
    }

    public void redeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void start(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void stop(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void undeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public DeployerType getType() {
        return DeployerType.LOCAL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

