/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.jetty.Jetty5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalDeployer;

public class Jetty5xEmbeddedLocalDeployer
extends AbstractJettyEmbeddedLocalDeployer {
    public Jetty5xEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super(container);
    }

    public Object deployWebApp(Deployable deployable) {
        this.getLogger().info("Deploying [" + deployable.getFile() + "]", ((Object)((Object)this)).getClass().getName());
        if (deployable.getType() == DeployableType.WAR) {
            try {
                Jetty5xEmbeddedLocalContainer container = (Jetty5xEmbeddedLocalContainer)this.getContainer();
                Class<?> wac = container.getClassLoader().loadClass("org.mortbay.jetty.servlet.WebApplicationContext");
                Object webAppContext = container.getServer().getClass().getMethod("addWebApplication", String.class, String.class).invoke(container.getServer(), Jetty5xEmbeddedLocalDeployer.getContext(deployable), deployable.getFile());
                String[] virtualHosts = this.getVirtualHosts();
                for (int i = 0; virtualHosts != null && i < virtualHosts.length; ++i) {
                    wac.getMethod("addVirtualHost", class$java$lang$String == null ? Jetty5xEmbeddedLocalDeployer.class$("java.lang.String") : class$java$lang$String).invoke(webAppContext, virtualHosts[i]);
                }
                if (this.getExtractWar() != null) {
                    wac.getMethod("setExtractWAR", Boolean.TYPE).invoke(webAppContext, this.getExtractWar());
                }
                if (this.getParentLoaderPriority() != null) {
                    wac.getMethod("setClassLoaderJava2Compliant", Boolean.TYPE).invoke(webAppContext, this.getParentLoaderPriority());
                }
                container.setDefaultRealm(webAppContext);
                wac.getMethod("start", null).invoke(webAppContext, null);
                return webAppContext;
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", (Throwable)e);
            }
        }
        throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
    }

    public void undeployWebApp(Deployable deployable) {
        this.stop(deployable);
        try {
            Jetty5xEmbeddedLocalContainer container = (Jetty5xEmbeddedLocalContainer)this.getContainer();
            Object deployedWebAppContext = Jetty5xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            Class<?> wac = container.getClassLoader().loadClass("org.mortbay.jetty.servlet.WebApplicationContext");
            wac.getMethod("destroy", null).invoke(deployedWebAppContext, null);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void redeploy(Deployable deployable) {
        this.undeploy(deployable);
        this.deploy(deployable);
    }

    public void start(Deployable deployable) {
        try {
            Jetty5xEmbeddedLocalContainer container = (Jetty5xEmbeddedLocalContainer)this.getContainer();
            Object deployedWebAppContext = Jetty5xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            Class<?> wac = container.getClassLoader().loadClass("org.mortbay.jetty.servlet.WebApplicationContext");
            wac.getMethod("start", null).invoke(deployedWebAppContext, null);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to start [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void stop(Deployable deployable) {
        try {
            Jetty5xEmbeddedLocalContainer container = (Jetty5xEmbeddedLocalContainer)this.getContainer();
            Object deployedWebAppContext = Jetty5xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            Class<?> wac = container.getClassLoader().loadClass("org.mortbay.jetty.servlet.WebApplicationContext");
            wac.getMethod("stop", null).invoke(deployedWebAppContext, null);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to stop [" + deployable.getFile() + "]", (Throwable)e);
        }
    }
}

