/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty9xInstalledLocalContainer;
import org.codehaus.cargo.util.CargoException;

public class Jetty10xInstalledLocalContainer
extends Jetty9xInstalledLocalContainer {
    public static final String ID = "jetty10x";
    public static final String DEFAULT_MODULES = "server,ext,http,annotations,plus,jsp,deploy";

    public Jetty10xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected String getJettyPortPropertyName() {
        return "jetty.http.port";
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected String[] getStartArguments(String classpath) {
        String configuredModules = this.getConfiguration().getPropertyValue("cargo.jetty.modules");
        if (configuredModules == null || configuredModules.trim().length() == 0) {
            throw new CargoException("Configuration property [cargo.jetty.modules] not set");
        }
        String[] modules = configuredModules.split(",");
        String[] startArguments = new String[modules.length + (classpath == null ? 0 : 1)];
        for (int i = 0; i < modules.length; ++i) {
            startArguments[i] = "--module=" + modules[i];
        }
        if (classpath != null) {
            startArguments[startArguments.length - 1] = "path=" + classpath;
        }
        return startArguments;
    }

    @Override
    protected String[] getStopArguments() {
        return new String[]{"STOP.PORT=" + this.getConfiguration().getPropertyValue("cargo.rmi.port"), "STOP.KEY=secret"};
    }
}

