/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.Jetty5xEmbeddedStandaloneLocalConfigurationCapability;

public class Jetty5xEmbeddedStandaloneLocalConfiguration
extends AbstractJettyEmbeddedStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Jetty5xEmbeddedStandaloneLocalConfigurationCapability();

    public Jetty5xEmbeddedStandaloneLocalConfiguration(String dir) {
        super(dir);
        System.setProperty("org.mortbay.log.LogFactory.noDiscovery", "true");
    }

    @Override
    public ConfigurationCapability getCapability() {
        return capability;
    }

    @Override
    protected void activateLogging(LocalContainer container) throws Exception {
        ClassLoader cl = ((EmbeddedLocalContainer)container).getClassLoader();
        Class<?> logFactoryClass = cl.loadClass("org.mortbay.log.LogFactory");
        Class<?> outputStreamLogSinkClass = cl.loadClass("org.mortbay.log.OutputStreamLogSink");
        Class<?> sinkClass = cl.loadClass("org.mortbay.log.LogSink");
        Object logFactory = logFactoryClass.getMethod("getFactory", new Class[0]).invoke(null, null);
        if (container.getOutput() != null) {
            Object logInstance = logFactory.getClass().getMethod("getInstance", String.class).invoke(logFactory, new Object[]{null});
            logInstance.getClass().getMethod("reset", new Class[0]).invoke(logInstance, new Object[0]);
            Object sink = outputStreamLogSinkClass.getConstructor(String.class).newInstance(container.getOutput());
            logInstance.getClass().getMethod("add", sinkClass).invoke(logInstance, sink);
            outputStreamLogSinkClass.getMethod("setAppend", Boolean.TYPE).invoke(sink, container.isAppend());
        } else {
            this.getLogger().info("Logging for Jetty container deferred to JCL discovery mechanism", ((Object)((Object)this)).getClass().getName());
        }
    }

    public String toString() {
        return "Jetty 5.x Embedded Standalone Configuration";
    }
}

