/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalDeployer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.JettyStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty6xStandaloneLocalConfiguration
extends AbstractJettyStandaloneLocalConfiguration {
    private static final List<String> WEBDEFAULT_XML_FILE = Arrays.asList("webdefault.xml");
    private static ConfigurationCapability capability = new JettyStandaloneLocalConfigurationCapability();

    public Jetty6xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    @Override
    public void doConfigure(LocalContainer container) throws Exception {
        for (String webDefaultXmlFile : this.getWebdefaultFiles()) {
            this.addXmlReplacement("etc/" + webDefaultXmlFile, "//servlet/init-param/param-name[text()='useFileMappedBuffer']/parent::init-param/param-value", null, "cargo.jetty.servlet.default.useFileMappedBuffer");
        }
        super.doConfigure(container);
        String sessionPath = this.getPropertyValue("cargo.jetty.session.path");
        String sessionContextParam = "";
        if (sessionPath != null) {
            sessionContextParam = "  <context-param>\n    <param-name>org.mortbay.jetty.servlet.SessionPath</param-name>\n    <param-value>" + sessionPath + "</param-value>\n  </context-param>\n";
            HashMap<String, String> replacements = new HashMap<String, String>(1);
            replacements.put("</web-app>", sessionContextParam + "</web-app>");
            for (String webDefaultXmlFile : this.getWebdefaultFiles()) {
                String webdefault = this.getFileHandler().append(this.getHome(), "etc/" + webDefaultXmlFile);
                this.getFileHandler().replaceInFile(webdefault, replacements, StandardCharsets.UTF_8, false);
            }
        }
    }

    @Override
    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty6xInstalledLocalDeployer deployer = new Jetty6xInstalledLocalDeployer((LocalContainer)container);
        return deployer;
    }

    protected List<String> getWebdefaultFiles() {
        return WEBDEFAULT_XML_FILE;
    }

    public String toString() {
        return "Jetty 6.x Standalone Configuration";
    }
}

