/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.jetty.Jetty6xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty7x8xInstalledLocalDeployer;
import org.codehaus.cargo.container.jetty.internal.Jetty7xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.jetty.internal.JettyUtils;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty7xStandaloneLocalConfiguration
extends Jetty6xStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Jetty7xStandaloneLocalConfigurationCapability();

    public Jetty7xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.jetty.realm.name", "Cargo Test Realm");
    }

    @Override
    public ConfigurationCapability getCapability() {
        return capability;
    }

    @Override
    public void doConfigure(LocalContainer container) throws Exception {
        super.doConfigure(container);
        String etcDir = this.getFileHandler().append(this.getHome(), "etc");
        HashMap<String, String> jettyXmlReplacements = new HashMap<String, String>();
        jettyXmlReplacements.put("<Property", "<SystemProperty");
        if (this.getUsers() != null && !this.getUsers().isEmpty()) {
            JettyUtils.createRealmFile(this.getUsers(), etcDir, this.getFileHandler());
            jettyXmlReplacements.put("</Configure>", this.configureRealmXml() + "</Configure>");
        }
        if (this.getDataSources() != null && !this.getDataSources().isEmpty()) {
            this.configureDatasource(container, etcDir);
        }
        this.getFileHandler().replaceInFile(this.getFileHandler().append(etcDir, "jetty.xml"), jettyXmlReplacements, StandardCharsets.UTF_8);
    }

    @Override
    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty7x8xInstalledLocalDeployer deployer = new Jetty7x8xInstalledLocalDeployer((LocalContainer)container);
        return deployer;
    }

    protected String configureRealmXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Call name=\"addBean\">\n");
        sb.append("  <Arg>\n");
        sb.append("    <New class=\"org.eclipse.jetty.security.HashLoginService\">\n");
        sb.append("      <Set name=\"name\">" + this.getPropertyValue("cargo.jetty.realm.name") + "</Set>\n");
        sb.append("      <Set name=\"config\"><SystemProperty name=\"config.home\" default=\".\"/>/etc/cargo-realm.properties</Set>\n");
        sb.append("    </New>\n");
        sb.append("  </Arg>\n");
        sb.append("</Call>\n");
        return sb.toString();
    }

    protected void configureDatasource(LocalContainer container, String etcDir) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<Call name=\"setAttribute\">\n");
        sb.append("  <Arg>org.eclipse.jetty.webapp.configuration</Arg>\n");
        sb.append("  <Arg>\n");
        sb.append("    <Array type=\"java.lang.String\">\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.WebInfConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.WebXmlConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.MetaInfConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.FragmentConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.plus.webapp.EnvConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.plus.webapp.PlusConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.JettyWebXmlConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.TagLibConfiguration</Item>\n");
        sb.append("    </Array>\n");
        sb.append("  </Arg>\n");
        sb.append("</Call>\n");
        this.createDatasourceDefinitions(sb, container);
        HashMap<String, String> jettyXmlReplacements = new HashMap<String, String>();
        jettyXmlReplacements.put("</Configure>", sb.toString() + "</Configure>");
        this.getFileHandler().replaceInFile(this.getFileHandler().append(etcDir, "jetty.xml"), jettyXmlReplacements, StandardCharsets.UTF_8);
    }

    protected void createDatasourceDefinitions(StringBuilder sb, LocalContainer container) throws IOException {
        for (DataSource ds : this.getDataSources()) {
            sb.append("\n");
            sb.append("<New id=\"" + ds.getId() + "\" class=\"org.eclipse.jetty.plus.jndi.Resource\">\n");
            sb.append("  <Arg>" + ds.getJndiLocation() + "</Arg>\n");
            sb.append("  <Arg>\n");
            sb.append("    <New class=\"com.mchange.v2.c3p0.ComboPooledDataSource\">\n");
            sb.append("      <Set name=\"driverClass\">" + ds.getDriverClass() + "</Set>\n");
            sb.append("      <Set name=\"jdbcUrl\">" + ds.getUrl() + "</Set>\n");
            sb.append("      <Set name=\"user\">" + ds.getUsername() + "</Set>\n");
            sb.append("      <Set name=\"password\">" + ds.getPassword() + "</Set>\n");
            sb.append("    </New>\n");
            sb.append("  </Arg>\n");
            sb.append("</New>\n");
        }
        String mchangeCommonsFile = this.getFileHandler().append(this.getHome(), "lib/ext/mchange-commons-java.jar");
        try (InputStream mchangeCommonsReader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/codehaus/cargo/container/jetty/datasource/mchange-commons-java.jar");
             OutputStream mchangeCommonsWriter = this.getFileHandler().getOutputStream(mchangeCommonsFile);){
            this.getFileHandler().copy(mchangeCommonsReader, mchangeCommonsWriter);
        }
        String c3p0File = this.getFileHandler().append(this.getHome(), "lib/ext/c3p0.jar");
        try (InputStream c3p0Reader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/codehaus/cargo/container/jetty/datasource/c3p0.jar");
             OutputStream c3p0Writer = this.getFileHandler().getOutputStream(c3p0File);){
            this.getFileHandler().copy(c3p0Reader, c3p0Writer);
        }
        InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
        installedContainer.addExtraClasspath(mchangeCommonsFile);
        installedContainer.addExtraClasspath(c3p0File);
    }

    @Override
    public String toString() {
        return "Jetty 7.x Standalone Configuration";
    }
}

