/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.Jetty6xEmbeddedStandaloneLocalConfigurationCapability;

public class Jetty6xEmbeddedStandaloneLocalConfiguration
extends AbstractJettyEmbeddedStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new Jetty6xEmbeddedStandaloneLocalConfigurationCapability();

    public Jetty6xEmbeddedStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.addXmlReplacement("etc/webdefault.xml", "//servlet/init-param/param-name[text()='useFileMappedBuffer']/parent::init-param/param-value", null, "cargo.jetty.servlet.default.useFileMappedBuffer");
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    public void doConfigure(LocalContainer container) throws Exception {
        super.doConfigure(container);
        String sessionPath = this.getPropertyValue("cargo.jetty.session.path");
        if (sessionPath != null) {
            String sessionContextParam = "  <context-param>\n    <param-name>org.mortbay.jetty.servlet.SessionPath</param-name>\n    <param-value>" + sessionPath + "</param-value>\n  </context-param>\n";
            HashMap<String, String> replacements = new HashMap<String, String>(1);
            replacements.put("</web-app>", sessionContextParam + "</web-app>");
            String webdefault = this.getFileHandler().append(this.getHome(), "etc/webdefault.xml");
            this.getFileHandler().replaceInFile(webdefault, replacements, StandardCharsets.UTF_8, false);
        }
    }

    @Override
    protected void activateLogging(LocalContainer container) {
        this.getLogger().info("Jetty 6.x log configuration not implemented", ((Object)((Object)this)).getClass().getName());
    }

    public String toString() {
        return "Jetty 6.x Embedded Standalone Configuration";
    }
}

