/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.jetty.Jetty11xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty12xInstalledLocalDeployer;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty12xStandaloneLocalConfiguration
extends Jetty11xStandaloneLocalConfiguration {
    private static final List<String> WEBDEFAULT_XML_FILES = Arrays.asList("webdefault-ee8.xml", "webdefault-ee9.xml", "webdefault-ee10.xml");

    public Jetty12xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.jetty.modules", "server,ext,http,ee10-annotations,ee10-plus,ee10-jsp,ee10-deploy");
        this.setProperty("cargo.jetty.deployer.ee.version", "ee10");
    }

    @Override
    protected List<String> getWebdefaultFiles() {
        return WEBDEFAULT_XML_FILES;
    }

    @Override
    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty12xInstalledLocalDeployer deployer = new Jetty12xInstalledLocalDeployer((LocalContainer)container);
        return deployer;
    }

    @Override
    protected String configureRealmXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Call id=\"ResourceFactory\" class=\"org.eclipse.jetty.util.resource.ResourceFactory\" name=\"of\">\n");
        sb.append("  <Arg><Ref refid=\"Server\" /></Arg>\n");
        sb.append("  <Call id=\"realmResource\" name=\"newResource\">\n");
        sb.append("    <Arg>\n");
        sb.append("      <Property name=\"cargo.realm\" default=\"etc/cargo-realm.properties\" />\n");
        sb.append("    </Arg>\n");
        sb.append("  </Call>\n");
        sb.append("</Call>\n\n");
        sb.append("<Call name=\"addBean\">\n");
        sb.append("  <Arg>\n");
        sb.append("    <New class=\"org.eclipse.jetty.security.HashLoginService\">\n");
        sb.append("      <Set name=\"name\">" + this.getPropertyValue("cargo.jetty.realm.name") + "</Set>\n");
        sb.append("      <Set name=\"config\"><Ref refid=\"realmResource\"/></Set>\n");
        sb.append("    </New>\n");
        sb.append("  </Arg>\n");
        sb.append("</Call>\n");
        return sb.toString();
    }

    @Override
    protected void configureDatasource(LocalContainer container, String etcDir) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.createDatasourceDefinitions(sb, container);
    }

    @Override
    public String toString() {
        return "Jetty 12.x Standalone Configuration";
    }
}

