/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty8xEmbeddedLocalContainer;

public class Jetty9xEmbeddedLocalContainer
extends Jetty8xEmbeddedLocalContainer {
    public static final String ID = "jetty9x";

    public Jetty9xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected void configureJettyConnectors() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> selectConnectorClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.ServerConnector");
        Object connector = selectConnectorClass.getConstructor(this.server.getClass()).newInstance(this.server);
        selectConnectorClass.getMethod("setPort", Integer.TYPE).invoke(connector, Integer.parseInt(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        Class<?> connectorClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.Connector");
        Object connectorArray = Array.newInstance(connectorClass, 1);
        Array.set(connectorArray, 0, connector);
        this.getServer().getClass().getMethod("addConnector", connectorClass).invoke(this.getServer(), connector);
    }

    @Override
    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            super.createServerObject();
            Class<?> webAppContextClass = this.getClassLoader().loadClass("org.eclipse.jetty.webapp.WebAppContext");
            if (webAppContextClass.getPackage().getImplementationVersion() != null && (webAppContextClass.getPackage().getImplementationVersion().startsWith("9.3.") || webAppContextClass.getPackage().getImplementationVersion().startsWith("9.4."))) {
                String[] dftServerClasses = (String[])webAppContextClass.getDeclaredField("__dftServerClasses").get(null);
                ArrayList<String> dftServerClassesList = new ArrayList<String>(dftServerClasses.length + 2);
                dftServerClassesList.add("-org.eclipse.jetty.cdi.");
                dftServerClassesList.add("-org.eclipse.jetty.cdi.websocket.");
                dftServerClassesList.addAll(Arrays.asList(dftServerClasses));
                dftServerClasses = new String[dftServerClassesList.size()];
                dftServerClasses = dftServerClassesList.toArray(dftServerClasses);
                this.server.getClass().getMethod("setAttribute", String.class, Object.class).invoke(this.server, "org.eclipse.jetty.webapp.serverClasses", dftServerClasses);
                String[] dftSystemClasses = (String[])webAppContextClass.getDeclaredField("__dftSystemClasses").get(null);
                ArrayList<String> dftSystemClassesList = new ArrayList<String>(dftSystemClasses.length + 2);
                dftSystemClassesList.addAll(Arrays.asList(dftSystemClasses));
                dftSystemClassesList.add("org.eclipse.jetty.cdi.");
                dftSystemClassesList.add("org.eclipse.jetty.cdi.websocket.");
                dftSystemClasses = new String[dftSystemClassesList.size()];
                dftSystemClasses = dftSystemClassesList.toArray(dftSystemClasses);
                this.server.getClass().getMethod("setAttribute", String.class, Object.class).invoke(this.server, "org.eclipse.jetty.webapp.systemClasses", dftSystemClasses);
            }
        }
    }
}

