/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.util.FileHandler;

public final class JettyUtils {
    private JettyUtils() {
    }

    public static String getExtraClasspath(WAR war, boolean xml) {
        CharSequence[] extraClasspath = war.getExtraClasspath();
        if (extraClasspath == null || extraClasspath.length <= 0) {
            return null;
        }
        String result = String.join((CharSequence)";", extraClasspath);
        if (xml) {
            result = result.replace("&", "&amp;");
        }
        return result;
    }

    public static void createRealmFile(List<User> users, String etcDir, FileHandler fileHandler) {
        StringBuilder sb = new StringBuilder();
        for (User user : users) {
            sb.append(user.getName());
            sb.append(": ");
            sb.append(user.getPassword().replace("\\", "\\\\"));
            for (String role : user.getRoles()) {
                sb.append(',').append(role);
            }
            sb.append("\n");
        }
        fileHandler.writeTextFile(fileHandler.append(etcDir, "cargo-realm.properties"), sb.toString(), StandardCharsets.ISO_8859_1);
    }
}

