/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.Jetty12xInstalledLocalContainer;
import org.codehaus.cargo.container.jetty.Jetty9x10x11xInstalledLocalDeployer;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;

public class Jetty12xInstalledLocalDeployer
extends Jetty9x10x11xInstalledLocalDeployer {
    private static final Map<String, String> EE_VERSION_CONFIGURATION_XML_MAP = new HashMap<String, String>(3){
        {
            this.put("ee8", "");
            this.put("ee9", "_9_0");
            this.put("ee10", "_10_0");
        }
    };
    private static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("(\\d+(\\.\\d+)*).*");

    public Jetty12xInstalledLocalDeployer(LocalContainer container) {
        super(container);
    }

    @Override
    protected String createContextXml(WAR war) {
        String eeVersion = this.getContainer().getConfiguration().getPropertyValue("cargo.jetty.deployer.ee.version");
        String eeConfigure = EE_VERSION_CONFIGURATION_XML_MAP.get(eeVersion);
        if (eeConfigure == null) {
            throw new CargoException("Specified EE version is invalid. Possible values: " + EE_VERSION_CONFIGURATION_XML_MAP.values());
        }
        String contextPropertiesFile = this.getContextFilename(war, "properties");
        this.getFileHandler().writeTextFile(contextPropertiesFile, "environment=" + eeVersion + FileHandler.NEW_LINE, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"  encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"https://eclipse.dev/jetty/configure" + eeConfigure + ".dtd\">\n");
        sb.append("<Configure class=\"org.eclipse.jetty." + eeVersion + ".webapp.WebAppContext\">\n");
        sb.append("  <Set name=\"contextPath\">/" + war.getContext() + "</Set>\n");
        sb.append("  <Set name=\"war\">" + war.getFile() + "</Set>\n");
        sb.append("  <Set name=\"extractWAR\">true</Set>\n");
        sb.append("  <Set name=\"defaultsDescriptor\"><SystemProperty name=\"config.home\" default=\".\"/>/etc/webdefault-" + eeVersion + ".xml</Set>\n");
        String resourceClassName = Jetty12xInstalledLocalDeployer.getJettyResourceClassname(((Jetty12xInstalledLocalContainer)this.getContainer()).getVersion(), eeVersion);
        for (DataSource ds : this.getContainer().getConfiguration().getDataSources()) {
            sb.append("  <New id=\"" + ds.getId() + "\" class=\"" + resourceClassName + "\">\n");
            sb.append("    <Arg>" + ds.getJndiLocation() + "</Arg>\n");
            sb.append("    <Arg>\n");
            sb.append("      <New class=\"com.mchange.v2.c3p0.ComboPooledDataSource\">\n");
            sb.append("        <Set name=\"driverClass\">" + ds.getDriverClass() + "</Set>\n");
            sb.append("        <Set name=\"jdbcUrl\">" + ds.getUrl() + "</Set>\n");
            sb.append("        <Set name=\"user\">" + ds.getUsername() + "</Set>\n");
            sb.append("        <Set name=\"password\">" + ds.getPassword() + "</Set>\n");
            sb.append("      </New>\n");
            sb.append("    </Arg>\n");
            sb.append("  </New>\n");
        }
        sb.append(this.getExtraClasspathXmlFragment(war));
        sb.append(this.getSharedClasspathXmlFragment());
        sb.append("</Configure>\n");
        return sb.toString();
    }

    public static String getJettyResourceClassname(String jettyVersion, String eeVersion) {
        Matcher matcher = VERSION_NUMBER_PATTERN.matcher(jettyVersion);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Version [" + jettyVersion + "] doesn't match " + VERSION_NUMBER_PATTERN);
        }
        String[] versionParts = matcher.group(1).split("\\.");
        StringBuilder resourceClassName = new StringBuilder("org.eclipse.jetty.");
        if (versionParts.length > 2 && Integer.parseInt(versionParts[0]) == 12 && Integer.parseInt(versionParts[1]) == 0 && Integer.parseInt(versionParts[2]) < 5) {
            resourceClassName.append(eeVersion + ".");
        }
        return resourceClassName.append("plus.jndi.Resource").toString();
    }
}

