/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.JettyUtils;
import org.codehaus.cargo.container.property.User;

public class Jetty7xEmbeddedLocalContainer
extends Jetty6xEmbeddedLocalContainer {
    public static final String ID = "jetty7x";

    public Jetty7xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void setDefaultRealm(Object webapp) throws Exception {
        if (this.defaultRealm != null) {
            Object securityHandler = webapp.getClass().getMethod("getSecurityHandler", new Class[0]).invoke(webapp, new Object[0]);
            Class<?> userRealmClass = this.getClassLoader().loadClass("org.eclipse.jetty.security.LoginService");
            securityHandler.getClass().getMethod("setLoginService", userRealmClass).invoke(securityHandler, this.defaultRealm);
            Class<?> authenticatorClass = this.getClassLoader().loadClass("org.eclipse.jetty.security.Authenticator");
            Object basicAuthenticator = this.getClassLoader().loadClass("org.eclipse.jetty.security.authentication.BasicAuthenticator").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            securityHandler.getClass().getMethod("setAuthenticator", authenticatorClass).invoke(securityHandler, basicAuthenticator);
        }
    }

    @Override
    protected String getWebappContextClassname() {
        return "org.eclipse.jetty.webapp.WebAppContext";
    }

    @Override
    protected void configureJettyConnectors() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> selectConnectorClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.nio.SelectChannelConnector");
        Object connector = selectConnectorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        selectConnectorClass.getMethod("setPort", Integer.TYPE).invoke(connector, Integer.parseInt(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        Class<?> connectorClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.Connector");
        Object connectorArray = Array.newInstance(connectorClass, 1);
        Array.set(connectorArray, 0, connector);
        this.getServer().getClass().getMethod("addConnector", connectorClass).invoke(this.getServer(), connector);
    }

    @Override
    protected void addJettyHandlers() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.handlerClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.Handler");
        this.handlers = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.HandlerCollection").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.contextHandlers = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandlerCollection").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object defaultHandler = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.DefaultHandler").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object handlerArray = Array.newInstance(this.handlerClass, 2);
        Array.set(handlerArray, 0, this.contextHandlers);
        Array.set(handlerArray, 1, defaultHandler);
        this.handlers.getClass().getMethod("setHandlers", handlerArray.getClass()).invoke(this.handlers, handlerArray);
        this.getServer().getClass().getMethod("setHandler", this.handlerClass).invoke(this.getServer(), this.handlers);
        this.addHandlerMethod = this.contextHandlers.getClass().getMethod("addHandler", this.handlerClass);
        this.removeHandlerMethod = this.contextHandlers.getClass().getMethod("removeHandler", this.handlerClass);
    }

    @Override
    protected void setSecurityRealm() throws Exception {
        if (this.getConfiguration().getUsers() != null && !this.getConfiguration().getUsers().isEmpty()) {
            Class<?> credentialClass;
            Class<?> realmClass = this.getClassLoader().loadClass("org.eclipse.jetty.security.HashLoginService");
            try {
                credentialClass = this.getClassLoader().loadClass("org.eclipse.jetty.http.security.Credential");
            }
            catch (ClassNotFoundException e) {
                credentialClass = this.getClassLoader().loadClass("org.eclipse.jetty.util.security.Credential");
            }
            try {
                this.defaultRealm = realmClass.getConstructor(String.class).newInstance(this.getConfiguration().getPropertyValue("cargo.jetty.realm.name"));
                Method putUser = realmClass.getMethod("putUser", String.class, credentialClass, String[].class);
                for (User user : this.getConfiguration().getUsers()) {
                    String userName = user.getName();
                    Object credential = credentialClass.getMethod("getCredential", String.class).invoke(credentialClass, user.getPassword());
                    String[] roles = user.getRoles().toArray(new String[user.getRoles().size()]);
                    putUser.invoke(this.defaultRealm, userName, credential, roles);
                }
            }
            catch (NoSuchMethodException putUser) {
                String etcDir = this.getFileHandler().append(this.getConfiguration().getHome(), "etc");
                JettyUtils.createRealmFile(this.getConfiguration().getUsers(), etcDir, this.getFileHandler());
                try {
                    this.defaultRealm = realmClass.getConstructor(String.class, String.class).newInstance(this.getConfiguration().getPropertyValue("cargo.jetty.realm.name"), this.getFileHandler().append(etcDir, "cargo-realm.properties"));
                }
                catch (NoSuchMethodException ctor) {
                    Class<?> resourceClass = this.getClassLoader().loadClass("org.eclipse.jetty.util.resource.Resource");
                    Class<?> pathResourceFactory = this.getClassLoader().loadClass("org.eclipse.jetty.util.resource.PathResourceFactory");
                    Method pathResourceConstructor = pathResourceFactory.getMethod("newResource", URI.class);
                    Object pathResource = pathResourceConstructor.invoke(pathResourceFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), new File(this.getFileHandler().append(etcDir, "cargo-realm.properties")).toURI());
                    this.defaultRealm = realmClass.getConstructor(String.class, resourceClass).newInstance(this.getConfiguration().getPropertyValue("cargo.jetty.realm.name"), pathResource);
                }
            }
            Object userRealmsArray = Array.newInstance(this.getClassLoader().loadClass("org.eclipse.jetty.security.LoginService"), 1);
            Array.set(userRealmsArray, 0, this.defaultRealm);
        }
    }

    @Override
    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            try {
                this.server = this.getClassLoader().loadClass("org.eclipse.jetty.server.Server").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create Jetty Server instance", (Throwable)e);
            }
            this.server.getClass().getMethod("setStopAtShutdown", Boolean.TYPE).invoke(this.server, Boolean.TRUE);
        }
    }
}

