/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import java.util.ArrayList;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalContainer;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public class Jetty7xInstalledLocalContainer
extends Jetty6xInstalledLocalContainer {
    public static final String ID = "jetty7x";
    protected String defaultFinalOptions = "jmx,resources,websocket,ext,plus";
    private String options;

    public Jetty7xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected void invoke(JvmLauncher java, boolean isGettingStarted) throws Exception {
        if ((this.getConfiguration().getPropertyValue("cargo.runtime.args") == null || !this.getConfiguration().getPropertyValue("cargo.runtime.args").contains("--ini=")) && LoggingLevel.HIGH.equalsLevel(this.getConfiguration().getPropertyValue("cargo.logging"))) {
            java.setSystemProperty("org.eclipse.jetty.DEBUG", "true");
        }
        super.invoke(java, isGettingStarted);
    }

    @Override
    protected String[] getStartArguments(String classpath) {
        String etc = this.getFileHandler().append(this.getConfiguration().getHome(), "etc");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getOptions());
        if (!this.getVersion().startsWith("7.0.")) {
            arguments.add("--ini");
        }
        arguments.add(this.getFileHandler().append(etc, "jetty-logging.xml"));
        arguments.add(this.getFileHandler().append(etc, "jetty.xml"));
        if (this.getFileHandler().exists(this.getFileHandler().append(etc, "jetty-deploy.xml"))) {
            arguments.add(this.getFileHandler().append(etc, "jetty-deploy.xml"));
        }
        if (this.getFileHandler().exists(this.getFileHandler().append(etc, "jetty-webapps.xml"))) {
            arguments.add(this.getFileHandler().append(etc, "jetty-webapps.xml"));
        }
        if (this.getFileHandler().exists(this.getFileHandler().append(etc, "jetty-contexts.xml"))) {
            arguments.add(this.getFileHandler().append(etc, "jetty-contexts.xml"));
        }
        if (this.getFileHandler().exists(this.getFileHandler().append(etc, "jetty-testrealm.xml"))) {
            arguments.add("--pre=" + this.getFileHandler().append(etc, "jetty-testrealm.xml"));
        }
        arguments.add("path=" + classpath);
        String[] result = new String[arguments.size()];
        return arguments.toArray(result);
    }

    protected synchronized String getOptions() {
        if (this.options == null) {
            StringBuilder options = new StringBuilder("OPTIONS=Server");
            File jspLib = new File(this.getHome(), "lib/jsp");
            if (jspLib.isDirectory()) {
                options.append(",jsp");
            } else {
                this.getLogger().warn("JSP librairies not found in " + jspLib + ", JSP support will be disabled", ((Object)((Object)this)).getClass().getName());
            }
            options.append("," + this.defaultFinalOptions);
            this.options = options.toString();
        }
        return this.options;
    }
}

