/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.jetty.Jetty8xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty9x10x11xInstalledLocalDeployer;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty9xStandaloneLocalConfiguration
extends Jetty8xStandaloneLocalConfiguration {
    public Jetty9xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    @Override
    public void doConfigure(LocalContainer container) throws Exception {
        String httpIni;
        super.doConfigure(container);
        InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
        this.getFileHandler().createDirectory(this.getHome(), "lib");
        this.getFileHandler().createDirectory(this.getHome(), "lib/ext");
        this.getFileHandler().createDirectory(this.getHome(), "resources");
        String startD = this.getFileHandler().append(installedContainer.getHome(), "start.d");
        if (this.getFileHandler().isDirectory(startD)) {
            this.getFileHandler().copyDirectory(startD, this.getHome() + "/start.d");
            httpIni = this.getFileHandler().append(this.getHome(), "start.d/http.ini");
        } else {
            String startIni = this.getFileHandler().append(installedContainer.getHome(), "start.ini");
            if (this.getFileHandler().exists(startIni)) {
                this.getFileHandler().copyFile(startIni, this.getHome() + "/start.ini");
            }
            httpIni = this.getFileHandler().append(this.getHome(), "start.ini");
        }
        if (this.getFileHandler().exists(httpIni)) {
            HashMap<String, String> httpIniReplacements = new HashMap<String, String>(1);
            httpIniReplacements.put("8080", this.getPropertyValue("cargo.servlet.port"));
            this.getFileHandler().replaceInFile(httpIni, httpIniReplacements, StandardCharsets.ISO_8859_1, false);
        }
        String libExt = this.getHome() + "/lib/ext";
        for (String extraClasspath : installedContainer.getExtraClasspath()) {
            String destinationFile = libExt + "/" + this.getFileHandler().getName(extraClasspath);
            this.getFileHandler().copyFile(extraClasspath, destinationFile);
        }
    }

    @Override
    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty9x10x11xInstalledLocalDeployer deployer = new Jetty9x10x11xInstalledLocalDeployer((LocalContainer)container);
        return deployer;
    }

    @Override
    public String toString() {
        return "Jetty 9.x Standalone Configuration";
    }
}

