/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployerType;
import org.codehaus.cargo.container.spi.deployer.AbstractEmbeddedLocalDeployer;

public abstract class AbstractJettyEmbeddedLocalDeployer
extends AbstractEmbeddedLocalDeployer {
    private static final Map<String, Object> DEPLOYED_WEBAPP_MAP = new HashMap<String, Object>();
    private String[] hosts;
    private Boolean extract;
    private Boolean copyWebApp;
    private Boolean parentLoaderPriority;

    public AbstractJettyEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super(container);
    }

    public abstract Object deployWebApp(Deployable var1);

    public abstract void undeployWebApp(Deployable var1);

    public void deploy(Deployable deployable) {
        Object o = this.deployWebApp(deployable);
        AbstractJettyEmbeddedLocalDeployer.addDeployedWebAppContext(AbstractJettyEmbeddedLocalDeployer.getContext(deployable), o);
    }

    public void undeploy(Deployable deployable) {
        this.undeployWebApp(deployable);
        AbstractJettyEmbeddedLocalDeployer.removeDeployedWebAppContext(AbstractJettyEmbeddedLocalDeployer.getContext(deployable));
    }

    public DeployerType getType() {
        return DeployerType.EMBEDDED;
    }

    public void setVirtualHosts(String[] hosts) {
        this.hosts = hosts == null ? null : new String[hosts.length];
        System.arraycopy(hosts, 0, this.hosts, 0, hosts.length);
    }

    public String[] getVirtualHosts() {
        return this.hosts;
    }

    public void setExtractWar(Boolean extract) {
        this.extract = extract;
    }

    public Boolean getExtractWar() {
        return this.extract;
    }

    public void setCopyWebApp(Boolean copy) {
        this.copyWebApp = copy;
    }

    public Boolean getCopyWebApp() {
        return this.copyWebApp;
    }

    public void setParentLoaderPriority(Boolean java2compliant) {
        this.parentLoaderPriority = java2compliant;
    }

    public Boolean getParentLoaderPriority() {
        return this.parentLoaderPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object getDeployedWebAppContext(Deployable deployable) {
        Map<String, Object> map = DEPLOYED_WEBAPP_MAP;
        synchronized (map) {
            return DEPLOYED_WEBAPP_MAP.get(AbstractJettyEmbeddedLocalDeployer.getContext(deployable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addDeployedWebAppContext(String context, Object deployedWebApp) {
        Map<String, Object> map = DEPLOYED_WEBAPP_MAP;
        synchronized (map) {
            DEPLOYED_WEBAPP_MAP.put(context, deployedWebApp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeDeployedWebAppContext(String context) {
        Map<String, Object> map = DEPLOYED_WEBAPP_MAP;
        synchronized (map) {
            DEPLOYED_WEBAPP_MAP.remove(context);
        }
    }

    public static String getContext(Deployable deployable) {
        return "/" + ((WAR)deployable).getContext();
    }
}

