/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalDeployer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.JettyStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty6xStandaloneLocalConfiguration
extends AbstractJettyStandaloneLocalConfiguration {
    private static final String[] WEBDEFAULT_XML_FILE = new String[]{"webdefault.xml"};
    private static final ConfigurationCapability CAPABILITY = new JettyStandaloneLocalConfigurationCapability();

    public Jetty6xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    public void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer installedLocalContainer = (InstalledLocalContainer)container;
        for (String webDefaultXmlFile : this.getWebdefaultFiles(installedLocalContainer)) {
            this.addUseFileMappedBufferXmlReplacement(webDefaultXmlFile);
        }
        super.doConfigure(container);
        String sessionPath = this.getPropertyValue("cargo.jetty.session.path");
        String sessionContextParam = "";
        if (sessionPath != null) {
            sessionContextParam = "  <context-param>\n    <param-name>org.mortbay.jetty.servlet.SessionPath</param-name>\n    <param-value>" + sessionPath + "</param-value>\n  </context-param>\n";
            HashMap<String, String> replacements = new HashMap<String, String>(1);
            replacements.put("</web-app>", sessionContextParam + "</web-app>");
            for (String webDefaultXmlFile : this.getWebdefaultFiles(installedLocalContainer)) {
                String webdefault = this.getFileHandler().append(this.getHome(), "etc/" + webDefaultXmlFile);
                this.getFileHandler().replaceInFile(webdefault, replacements, StandardCharsets.UTF_8, false);
            }
        }
    }

    @Override
    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty6xInstalledLocalDeployer deployer = new Jetty6xInstalledLocalDeployer((LocalContainer)container);
        return deployer;
    }

    protected String[] getWebdefaultFiles(InstalledLocalContainer container) {
        return WEBDEFAULT_XML_FILE;
    }

    protected void addUseFileMappedBufferXmlReplacement(String webDefaultXmlFile) {
        this.addXmlReplacement("etc/" + webDefaultXmlFile, "//servlet/init-param/param-name[text()='useFileMappedBuffer']/parent::init-param/param-value", null, "cargo.jetty.servlet.default.useFileMappedBuffer");
    }

    public String toString() {
        return "Jetty 6.x Standalone Configuration";
    }
}

