/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty8xInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public class Jetty9xInstalledLocalContainer
extends Jetty8xInstalledLocalContainer {
    public static final String ID = "jetty9x";

    public Jetty9xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void doStart(JvmLauncher java) throws Exception {
        String npnFolder = this.getFileHandler().append(this.getHome(), "modules/npn");
        if (this.getFileHandler().isDirectory(npnFolder)) {
            String closest = "";
            String expected = "npn-" + System.getProperty("java.version") + ".mod";
            for (String npnFile : this.getFileHandler().getChildren(npnFolder, new String[0])) {
                String npnFilename = this.getFileHandler().getName(npnFile);
                int distanceClosest = Math.abs(closest.compareTo(expected));
                int distanceCurrent = Math.abs(npnFilename.compareTo(expected));
                if (distanceCurrent >= distanceClosest) continue;
                closest = npnFilename;
            }
            if (!closest.isEmpty() && !closest.equals(expected)) {
                closest = this.getFileHandler().append(npnFolder, closest);
                expected = this.getFileHandler().append(npnFolder, expected);
                this.getFileHandler().copyFile(closest, expected);
            }
        }
        super.doStart(java);
    }

    @Override
    protected String[] getStartArguments(String classpath) {
        if (this.getVersion().startsWith("9.0.")) {
            String etc = this.getFileHandler().append(this.getConfiguration().getHome(), "etc");
            return new String[]{this.getOptions(), "--ini", this.getFileHandler().append(etc, "jetty-logging.xml"), this.getFileHandler().append(etc, "jetty.xml"), this.getFileHandler().append(etc, "jetty-annotations.xml"), this.getFileHandler().append(etc, "jetty-http.xml"), this.getFileHandler().append(etc, "jetty-plus.xml"), this.getFileHandler().append(etc, "jetty-deploy.xml"), "path=" + classpath};
        }
        return new String[]{"--module=" + (this.getVersion().startsWith("9.4.") ? "console-capture" : "logging"), "--module=server", "--module=deploy", "--module=websocket", "--module=jsp", "--module=ext", "--module=resources", "--module=http", "--module=plus", "--module=annotations", "path=" + classpath};
    }

    @Override
    protected String[] getStopArguments() {
        if (this.getVersion().startsWith("9.0.")) {
            return super.getStopArguments();
        }
        return new String[]{"STOP.PORT=" + this.getConfiguration().getPropertyValue("cargo.rmi.port"), "STOP.KEY=secret"};
    }
}

