/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.JettyExecutorThread;
import org.codehaus.cargo.container.property.User;

public class Jetty5xEmbeddedLocalContainer
extends AbstractJettyEmbeddedLocalContainer {
    public static final String ID = "jetty5x";
    private Object defaultRealm;

    public Jetty5xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected void doStart() throws Exception {
        this.createServerObject();
        Class<?> listenerClass = this.getClassLoader().loadClass("org.mortbay.http.SocketListener");
        Object listener = listenerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        listenerClass.getMethod("setPort", Integer.TYPE).invoke(listener, Integer.parseInt(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        this.getServer().getClass().getMethod("addListener", this.getClassLoader().loadClass("org.mortbay.http.HttpListener")).invoke(this.getServer(), listener);
        this.setSecurityRealm();
        String webdefault = new File(this.getConfiguration().getHome(), "etc/webdefault.xml").toURI().toString();
        for (Deployable deployable : this.getConfiguration().getDeployables()) {
            if (deployable.getType() == DeployableType.WAR) {
                Object webapp = this.getServer().getClass().getMethod("addWebApplication", String.class, String.class).invoke(this.getServer(), "/" + ((WAR)deployable).getContext(), deployable.getFile());
                webapp.getClass().getMethod("setDefaultsDescriptor", String.class).invoke(webapp, webdefault);
                this.setDefaultRealm(webapp);
                continue;
            }
            throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
        }
        this.getServer().getClass().getMethod("addWebApplication", String.class, String.class).invoke(this.getServer(), "/cargocpc", new File(this.getConfiguration().getHome(), "cargocpc.war").getPath());
        JettyExecutorThread jettyRunner = new JettyExecutorThread(this.getServer(), true);
        jettyRunner.setLogger(this.getLogger());
        jettyRunner.start();
    }

    protected void setSecurityRealm() throws Exception {
        if (!this.getConfiguration().getUsers().isEmpty()) {
            Class<?> realmClass = this.getClassLoader().loadClass("org.mortbay.http.HashUserRealm");
            Object defaultRealm = realmClass.getConstructor(String.class).newInstance(this.getConfiguration().getPropertyValue("cargo.jetty.realm.name"));
            for (User user : this.getConfiguration().getUsers()) {
                defaultRealm.getClass().getMethod("put", Object.class, Object.class).invoke(defaultRealm, user.getName(), user.getPassword());
                for (String role : user.getRoles()) {
                    defaultRealm.getClass().getMethod("addUserToRole", String.class, String.class).invoke(defaultRealm, user.getName(), role);
                }
            }
            this.getServer().getClass().getMethod("addRealm", this.getClassLoader().loadClass("org.mortbay.http.UserRealm")).invoke(this.getServer(), defaultRealm);
        }
    }

    protected void setDefaultRealm(Object webapp) throws Exception {
        if (this.defaultRealm != null) {
            webapp.getClass().getMethod("setRealm", this.defaultRealm.getClass()).invoke(webapp, this.defaultRealm);
        }
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Jetty 5.x Embedded";
    }
}

