/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.nio.charset.StandardCharsets;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.internal.JettyUtils;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty6x7x8xInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    private static final String DEPRECATED_CREATE_CONTEXT_XML = "cargo.jetty.createContextXml";

    public Jetty6x7x8xInstalledLocalDeployer(LocalContainer container) {
        super(container);
    }

    public String getDeployableDir(Deployable deployable) {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "webapps");
    }

    public String getContextsDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "contexts");
    }

    protected void doDeploy(String deployableDir, Deployable deployable) {
        String createContextXml = this.getContainer().getConfiguration().getPropertyValue(DEPRECATED_CREATE_CONTEXT_XML);
        if (createContextXml != null) {
            this.getLogger().warn("You are using the deprecated property [cargo.jetty.createContextXml]. Please replace it with [cargo.jetty.deployer.createContextXml], which was introduced with Codehaus Cargo 1.10.9.", ((Object)((Object)this)).getClass().getName());
        } else {
            createContextXml = this.getContainer().getConfiguration().getPropertyValue("cargo.jetty.deployer.createContextXml");
        }
        if (DeployableType.WAR.equals((Object)deployable.getType()) && Boolean.parseBoolean(createContextXml)) {
            WAR war = (WAR)deployable;
            String contextFile = this.getContextFilename(war, "xml");
            this.getLogger().info("Deploying WAR by creating Jetty context XML file in [" + contextFile + "]", ((Object)((Object)this)).getClass().getName());
            this.getFileHandler().writeTextFile(contextFile, this.createContextXml(war), StandardCharsets.UTF_8);
        } else {
            super.doDeploy(deployableDir, deployable);
        }
    }

    protected String getContextFilename(WAR war, String extension) {
        String contextDir = this.getContextsDir();
        String contextFile = war.getFilename().replace('/', '-');
        contextFile = war.isExpanded() ? contextFile + "." + extension : contextFile.substring(0, contextFile.length() - 3) + extension;
        return this.getFileHandler().append(contextDir, contextFile);
    }

    protected String createContextXml(WAR war) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure//EN\" \"http://jetty.mortbay.org/configure.dtd\">\n");
        sb.append("<Configure class=\"org.mortbay.jetty.webapp.WebAppContext\">\n");
        sb.append("  <Array id=\"plusConfig\" type=\"java.lang.String\">\n");
        sb.append("    <Item>org.mortbay.jetty.webapp.WebInfConfiguration</Item>\n");
        sb.append("    <Item>org.mortbay.jetty.plus.webapp.EnvConfiguration</Item>\n");
        sb.append("    <Item>org.mortbay.jetty.plus.webapp.Configuration</Item>\n");
        sb.append("    <Item>org.mortbay.jetty.webapp.JettyWebXmlConfiguration</Item>\n");
        sb.append("    <Item>org.mortbay.jetty.webapp.TagLibConfiguration</Item>\n");
        sb.append("  </Array>\n");
        sb.append("  <Set name=\"contextPath\">/" + war.getContext() + "</Set>\n");
        sb.append("  <Set name=\"war\">" + war.getFile() + "</Set>\n");
        sb.append("  <Set name=\"extractWAR\">true</Set>\n");
        sb.append("  <Set name=\"defaultsDescriptor\"><SystemProperty name=\"config.home\" default=\".\"/>/etc/webdefault.xml</Set>\n");
        sb.append("  <Set name=\"ConfigurationClasses\"><Ref id=\"plusConfig\"/></Set>\n");
        sb.append(this.getExtraClasspathXmlFragment(war));
        sb.append(this.getSharedClasspathXmlFragment());
        sb.append("</Configure>\n");
        return sb.toString();
    }

    protected String getSharedClasspathXmlFragment() {
        InstalledLocalContainer installedLocalContainer;
        String[] sharedClasspath;
        StringBuilder sb = new StringBuilder();
        if (this.getContainer() instanceof InstalledLocalContainer && (sharedClasspath = (installedLocalContainer = (InstalledLocalContainer)this.getContainer()).getSharedClasspath()) != null && sharedClasspath.length > 0) {
            sb.append("  <Set name=\"extraClasspath\">\n");
            for (String sharedClasspathElement : sharedClasspath) {
                sb.append("    ").append(sharedClasspathElement).append(";\n");
            }
            sb.append("  </Set>\n");
        }
        return sb.toString();
    }

    protected String getExtraClasspathXmlFragment(WAR war) {
        StringBuilder sb = new StringBuilder();
        String extraClasspath = JettyUtils.getExtraClasspath(war, true);
        if (extraClasspath != null) {
            sb.append("  <Set name=\"extraClasspath\">" + extraClasspath + "</Set>\n");
        }
        return sb.toString();
    }
}

