/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public abstract class AbstractJettyStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    public AbstractJettyStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "8079");
        this.setProperty("cargo.jetty.servlet.default.useFileMappedBuffer", "true");
        this.setProperty("cargo.jetty.deployer.createContextXml", "true");
    }

    protected abstract AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer var1);

    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer ilContainer = (InstalledLocalContainer)container;
        this.setupConfigurationDir();
        String etcDir = this.getFileHandler().createDirectory(this.getHome(), "etc");
        this.getFileHandler().copyDirectory(this.getFileHandler().append(ilContainer.getHome(), "etc"), etcDir);
        HashMap<String, String> replaceJettyHome = new HashMap<String, String>(1);
        replaceJettyHome.put("jetty.home", "config.home");
        for (String etcChild : this.getFileHandler().getChildren(etcDir, new String[0])) {
            if (this.getFileHandler().isDirectory(etcChild)) continue;
            this.getFileHandler().replaceInFile(etcChild, replaceJettyHome, StandardCharsets.UTF_8, true);
        }
        String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        this.getFileHandler().createDirectory(this.getHome(), "contexts");
        AbstractCopyingInstalledLocalDeployer deployer = this.createDeployer(ilContainer);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
    }
}

