/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.builder.ConfigurationBuilder;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.tomcat.internal.AbstractCatalinaStandaloneLocalConfiguration;
import org.codehaus.cargo.container.tomcat.internal.Tomcat5And6xConfigurationBuilder;

public class Tomcat5xStandaloneLocalConfiguration
extends AbstractCatalinaStandaloneLocalConfiguration {
    private Tomcat5And6xConfigurationBuilder configurationBuilder;

    public Tomcat5xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.tomcat.connector.emptySessionPath", "true");
        this.configurationBuilder = new Tomcat5And6xConfigurationBuilder();
    }

    protected ConfigurationBuilder createConfigurationBuilder(LocalContainer container) {
        return this.configurationBuilder;
    }

    protected void setupManager(LocalContainer container) {
        if (!(container instanceof EmbeddedLocalContainer)) {
            String from = ((InstalledLocalContainer)container).getHome();
            String to = this.getHome();
            this.getFileHandler().copyDirectory(from + "/server/webapps/manager", to + "/server/webapps/manager");
            this.getFileHandler().copyFile(from + "/server/lib/catalina.jar", to + "/server/lib/catalina.jar");
            this.getFileHandler().copyFile(from + "/conf/Catalina/localhost/manager.xml", to + "/conf/Catalina/localhost/manager.xml");
        }
    }

    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = super.createTomcatFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.connector.emptySessionPath", this.getPropertyValue("cargo.tomcat.connector.emptySessionPath"));
        return filterChain;
    }

    public String toString() {
        return "Tomcat 5.x Standalone Configuration";
    }

    protected Set getConfFiles() {
        Set files = super.getConfFiles();
        files.add("catalina.properties");
        files.add("context.xml");
        return files;
    }

    protected void setupTransactionManager() {
        Resource transactionManagerResource = new Resource("UserTransaction", "javax.transaction.UserTransaction");
        Properties parameters = new Properties();
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"jotm.timeout", (Object)"60");
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"factory", (Object)"org.objectweb.jotm.UserTransactionFactory");
        transactionManagerResource.setParameters((Map)parameters);
        this.getResources().add(transactionManagerResource);
    }

    protected String getXpathForResourcesParent() {
        return "//Context";
    }

    protected String getOrCreateResourceConfigurationFile(Resource rs, LocalContainer container) {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        return this.getFileHandler().append(confDir, "context.xml");
    }
}

