/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;

public class TomcatCopyingInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    private boolean shouldCopyWars = true;

    public TomcatCopyingInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "webapps");
    }

    public void setShouldCopyWars(boolean shouldCopyWars) {
        this.shouldCopyWars = shouldCopyWars;
    }

    protected void deployWar(String deployableDir, WAR war) {
        if (war instanceof TomcatWAR) {
            TomcatWAR tomcatWar = (TomcatWAR)war;
            if (tomcatWar.containsContextFile()) {
                super.deployWar(deployableDir, war);
            } else if (this.shouldCopyWars) {
                super.deployWar(deployableDir, war);
            }
        } else if (this.shouldCopyWars) {
            super.deployWar(deployableDir, war);
        }
    }

    protected void deployExpandedWar(String deployableDir, WAR war) {
        if (war instanceof TomcatWAR) {
            TomcatWAR tomcatWar = (TomcatWAR)war;
            if (tomcatWar.containsContextFile()) {
                String contextDir = this.getFileHandler().createDirectory(this.getContainer().getConfiguration().getHome(), "conf/Catalina/" + this.getContainer().getConfiguration().getPropertyValue("cargo.hostname"));
                this.getFileHandler().copyFile(this.getFileHandler().append(tomcatWar.getFile(), "META-INF/context.xml"), this.getFileHandler().append(contextDir, tomcatWar.getContext() + ".xml"));
            } else if (this.shouldCopyWars) {
                super.deployExpandedWar(deployableDir, war);
            }
        } else if (this.shouldCopyWars) {
            super.deployExpandedWar(deployableDir, war);
        }
    }

    public void undeploy(Deployable deployable) {
        if (!this.getContainer().getCapability().supportsDeployableType(deployable.getType())) {
            throw new ContainerException(this.getContainer().getName() + " doesn't support [" + deployable.getType().getType().toUpperCase() + "] archives. Got [" + deployable.getFile() + "]");
        }
        String deployableDir = this.getDeployableDir();
        try {
            String warLocation;
            if (deployable.getType() == DeployableType.WAR) {
                WAR war = (WAR)deployable;
                String context = war.getContext();
                this.getLogger().info("Undeploying context [" + context + "] from [" + deployableDir + "]...", ((Object)((Object)this)).getClass().getName());
                warLocation = war.isExpandedWar() ? this.getFileHandler().append(deployableDir, context) : this.getFileHandler().append(deployableDir, context + ".war");
                if (!this.getFileHandler().exists(warLocation)) {
                    throw new ContainerException("Failed to undeploy as there is no WAR at [" + warLocation + "]");
                }
            } else {
                throw new ContainerException("Only WAR undeployment is currently supported");
            }
            this.getLogger().info("Trying to delete WAR from [" + warLocation + "]...", ((Object)((Object)this)).getClass().getName());
            this.getFileHandler().delete(warLocation);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "] from [" + deployableDir + "]", (Throwable)e);
        }
    }
}

