/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.ResourceSupport;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatWAR;
import org.codehaus.cargo.container.tomcat.internal.TomcatStandaloneLocalConfigurationCapability;

public abstract class AbstractCatalinaStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder
implements ResourceSupport {
    private static ConfigurationCapability capability = new TomcatStandaloneLocalConfigurationCapability();

    public AbstractCatalinaStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager");
        this.setProperty("cargo.rmi.port", "8205");
        this.setProperty("cargo.servlet.uriencoding", "ISO-8859-1");
        this.setProperty("cargo.tomcat.ajp.port", "8009");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        FilterChain filterChain = this.createTomcatFilterChain();
        this.getFileHandler().createDirectory(this.getHome(), "temp");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        if (container instanceof InstalledLocalContainer) {
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] sharedClassPath = installedContainer.getSharedClasspath();
            StringBuilder tmp = new StringBuilder();
            if (sharedClassPath != null) {
                for (String element : sharedClassPath) {
                    tmp.append(',').append(this.escapePath(element));
                }
            }
            this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.common.loader", tmp.toString());
        }
        this.setupConfFiles(container, filterChain);
        this.setupManager(container);
        this.setupWebApps(container);
    }

    protected String escapePath(String path) {
        String escapedPath = path;
        if (escapedPath.contains("\\")) {
            if (escapedPath.contains(":\\")) {
                escapedPath = '/' + escapedPath;
            }
            escapedPath = escapedPath.replace('\\', '/');
        }
        return escapedPath;
    }

    public void configureDataSources(LocalContainer container) {
        super.configureDataSources(container);
        this.setupTransactionManager();
    }

    protected abstract void setupTransactionManager();

    protected Set getConfFiles() {
        HashSet<String> confFiles = new HashSet<String>();
        confFiles.add("server.xml");
        confFiles.add("tomcat-users.xml");
        confFiles.add("web.xml");
        return confFiles;
    }

    protected abstract void setupManager(LocalContainer var1);

    private void setupWebApps(LocalContainer container) {
        try {
            if (container instanceof EmbeddedLocalContainer) {
                Tomcat5xEmbeddedLocalDeployer deployer = new Tomcat5xEmbeddedLocalDeployer((EmbeddedLocalContainer)((Tomcat5xEmbeddedLocalContainer)container));
                deployer.deploy(this.getDeployables());
            } else {
                String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
                TomcatCopyingInstalledLocalDeployer deployer = new TomcatCopyingInstalledLocalDeployer((InstalledLocalContainer)container);
                deployer.setShouldDeployExpandedWARs(true);
                deployer.setShouldCopyWars(false);
                deployer.deploy(this.getDeployables());
                this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(appDir, "cargocpc.war"), this.getFileHandler());
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", (Throwable)e);
        }
    }

    private String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = cargoLoggingLevel.equalsIgnoreCase("low") ? "1" : (cargoLoggingLevel.equalsIgnoreCase("medium") ? "2" : "4");
        return level;
    }

    protected FilterChain createTomcatFilterChain() {
        FilterChain filterChain = this.getFilterChain();
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.logging.level", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.rmi.port", this.getPropertyValue("cargo.rmi.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.tomcat.ajp.port", this.getPropertyValue("cargo.tomcat.ajp.port"));
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.secure", String.valueOf("https".equalsIgnoreCase(this.getPropertyValue("cargo.protocol"))));
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.users", this.getSecurityToken());
        this.getAntUtils().addTokenToFilterChain(filterChain, "catalina.servlet.uriencoding", this.getPropertyValue("cargo.servlet.uriencoding"));
        StringBuilder webappTokenValue = new StringBuilder(" ");
        for (Deployable deployable : this.getDeployables()) {
            TomcatWAR tomcatWar;
            if (deployable.getType() != DeployableType.WAR) {
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            if (deployable instanceof TomcatWAR && (tomcatWar = (TomcatWAR)deployable).containsContextFile()) continue;
            webappTokenValue.append(this.createContextToken((WAR)deployable));
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "tomcat.webapps", webappTokenValue.toString());
        return filterChain;
    }

    protected String createContextToken(WAR deployable) {
        StringBuilder contextTokenValue = new StringBuilder();
        contextTokenValue.append("<Context path=\"");
        if (!"".equals(deployable.getContext()) && !"/".equals(deployable.getContext())) {
            contextTokenValue.append("/" + deployable.getContext());
        }
        contextTokenValue.append("\" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\">");
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }

    public String toString() {
        return "Catalina Standalone Configuration";
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected String getSecurityToken() {
        StringBuilder token = new StringBuilder(" ");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            for (User user : User.parseUsers((String)this.getPropertyValue("cargo.servlet.users"))) {
                token.append("<user ");
                token.append("name=\"" + user.getName() + "\" ");
                token.append("password=\"" + user.getPassword() + "\" ");
                token.append("roles=\"");
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    token.append(role);
                    if (!roles.hasNext()) continue;
                    token.append(',');
                }
                token.append("\"/>");
            }
        }
        return token.toString();
    }

    protected void setupConfFiles(LocalContainer container, FilterChain filterChain) throws IOException {
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        for (String file : this.getConfFiles()) {
            this.getResourceUtils().copyResource("/org/codehaus/cargo/container/internal/resources/" + container.getId() + "/" + file, this.getFileHandler().append(confDir, file), this.getFileHandler(), filterChain);
        }
    }

    protected String getXpathForDataSourcesParent() {
        return this.getXpathForResourcesParent();
    }

    public String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        return this.getOrCreateResourceConfigurationFile(null, container);
    }

    protected Map getNamespaces() {
        return Collections.EMPTY_MAP;
    }
}

