/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.internal.util.PropertyUtils;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractConfigurationBuilder;

public abstract class AbstractTomcatConfigurationBuilder
extends AbstractConfigurationBuilder {
    protected Map typeToFactory = new HashMap();

    public AbstractTomcatConfigurationBuilder() {
        this.typeToFactory.put("default", "org.apache.naming.factory.BeanFactory");
        this.typeToFactory.put("javax.mail.internet.MimePartDataSource", "org.apache.naming.factory.SendMailFactory");
        this.typeToFactory.put("javax.mail.Session", "org.apache.naming.factory.MailSessionFactory");
    }

    public String buildEntryForDriverConfiguredDataSourceWithNoTx(DataSource ds) {
        return this.convertDataSourceToResourceAndGetXMLEntry(ds);
    }

    protected String convertDataSourceToResourceAndGetXMLEntry(DataSource ds) {
        Resource dataSourceResource = this.convertToResource(ds);
        return this.toConfigurationEntry(dataSourceResource);
    }

    protected Resource convertToResource(DataSource ds) {
        Properties parameters = new Properties();
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"url", (Object)ds.getUrl());
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"username", (Object)ds.getUsername());
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"password", (Object)ds.getPassword());
        parameters.putAll((Map<?, ?>)ds.getConnectionProperties());
        Resource resource = new Resource(ds.getJndiLocation(), "javax.sql.DataSource");
        resource.setParameters((Map)parameters);
        PropertyUtils.setPropertyIfNotNull((Properties)parameters, (String)"driverClassName", (Object)ds.getDriverClass());
        return resource;
    }

    protected String getFactoryClassFor(String type) {
        String returnVal = (String)this.typeToFactory.get(type);
        if (returnVal == null) {
            returnVal = (String)this.typeToFactory.get("default");
        }
        return returnVal;
    }

    public String buildConfigurationEntryForXADataSourceConfiguredDataSource(DataSource ds) {
        throw new UnsupportedOperationException("Tomcat does not support XADataSource configured DataSource implementations.");
    }

    public String buildEntryForDriverConfiguredDataSourceWithLocalTx(DataSource ds) {
        throw new UnsupportedOperationException("Tomcat does not support " + ds.getTransactionSupport() + " for DataSource implementations.");
    }

    public String buildEntryForDriverConfiguredDataSourceWithXaTx(DataSource ds) {
        throw new UnsupportedOperationException("Tomcat does not support " + ds.getTransactionSupport() + " for DataSource implementations.");
    }
}

