/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatDeployableStatus;
import org.codehaus.cargo.container.tomcat.internal.TomcatManager;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;

public abstract class AbstractTomcatManagerDeployer
extends AbstractRemoteDeployer {
    private static final String NAME = "Cargo";
    private static final String VERSION = "1.0-SNAPSHOT";
    protected String managerContext = "/manager";
    private TomcatManager manager;

    public AbstractTomcatManagerDeployer(Container container) {
        this.setLogger(container.getLogger());
    }

    protected abstract Configuration getConfiguration();

    protected TomcatManager getTomcatManager() {
        if (this.manager == null) {
            this.manager = this.createManager(this.getConfiguration());
        }
        return this.manager;
    }

    public void deploy(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Deploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            this.getTomcatManager().deploy(this.getPath(deployable), new FileInputStream(file));
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to deploy [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to deploy [" + file + "]", (Throwable)exception);
        }
    }

    public void undeploy(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Undeploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable));
            if (!status.equals(TomcatDeployableStatus.NOT_FOUND)) {
                this.performUndeploy(deployable);
            } else {
                this.getLogger().debug("Deployable [" + ((WAR)deployable).getContext() + "] already undeployed", ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to undeploy [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to undeploy [" + file + "]", (Throwable)exception);
        }
    }

    protected abstract void performUndeploy(Deployable var1) throws TomcatManagerException, IOException;

    public void redeploy(Deployable deployable) {
        String file = deployable.getFile();
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable));
            if (!status.equals(TomcatDeployableStatus.NOT_FOUND)) {
                this.getLogger().info("Redeploying [" + file + "]", ((Object)((Object)this)).getClass().getName());
                this.undeploy(deployable);
            } else {
                this.getLogger().info("[" + file + "] is not deployed. Doing a fresh deployment.", ((Object)((Object)this)).getClass().getName());
            }
            this.deploy(deployable);
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to redeploy [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to redeploy [" + file + "]", (Throwable)exception);
        }
    }

    public void start(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Starting [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable));
            if (status.equals(TomcatDeployableStatus.STOPPED)) {
                this.getTomcatManager().start(this.getPath(deployable));
            } else {
                this.getLogger().debug("Deployable [" + ((WAR)deployable).getContext() + "] already started or doesn't exists", ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to start [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to start [" + file + "]", (Throwable)exception);
        }
    }

    public void stop(Deployable deployable) {
        String file = deployable.getFile();
        this.getLogger().info("Stopping [" + file + "]", ((Object)((Object)this)).getClass().getName());
        try {
            TomcatDeployableStatus status = this.getTomcatManager().getStatus(this.getPath(deployable));
            if (status.equals(TomcatDeployableStatus.RUNNING)) {
                this.getTomcatManager().stop(this.getPath(deployable));
            } else {
                this.getLogger().debug("Deployable [" + ((WAR)deployable).getContext() + "] already stopped or doesn't exists", ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to stop [" + file + "]", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to stop [" + file + "]", (Throwable)exception);
        }
    }

    public String list() {
        this.getLogger().debug("Getting the list of applications and their statuses", ((Object)((Object)this)).getClass().getName());
        try {
            return this.getTomcatManager().list();
        }
        catch (TomcatManagerException exception) {
            throw new ContainerException("Failed to get the list of applications", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ContainerException("Failed to get the list of applications", (Throwable)exception);
        }
    }

    protected TomcatManager createManager(Configuration configuration) {
        URL managerURL = this.getManagerURL(configuration);
        String username = configuration.getPropertyValue("cargo.remote.username");
        String password = configuration.getPropertyValue("cargo.remote.password");
        if (username == null || password == null) {
            throw new ContainerException("The [cargo.remote.username] and [cargo.remote.password] properties are mandatory and need to be defined in your configuration.");
        }
        TomcatManager manager = new TomcatManager(managerURL, username, password);
        manager.setLogger(this.getLogger());
        manager.setUserAgent("Cargo/1.0-SNAPSHOT");
        return manager;
    }

    private URL getManagerURL(Configuration configuration) {
        URL url;
        String managerURL = configuration.getPropertyValue("cargo.tomcat.manager.url");
        if (managerURL == null) {
            managerURL = configuration.getPropertyValue("cargo.protocol") + "://" + configuration.getPropertyValue("cargo.hostname") + ":" + configuration.getPropertyValue("cargo.servlet.port") + this.managerContext;
            this.getLogger().debug("Setting Tomcat Manager URL to " + managerURL, ((Object)((Object)this)).getClass().getName());
        }
        this.getLogger().debug("Tomcat Manager URL is " + managerURL, ((Object)((Object)this)).getClass().getName());
        try {
            url = new URL(managerURL);
        }
        catch (MalformedURLException e) {
            throw new ContainerException("Invalid Tomcat Manager URL [" + managerURL + "]", (Throwable)e);
        }
        return url;
    }

    protected String getPath(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
        }
        return "/" + ((WAR)deployable).getContext();
    }
}

